/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugin.util.io;

import biz.gabrys.maven.plugin.util.io.RegexFileFilterException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.filefilter.IOFileFilter;

public class RegexFileFilter
implements IOFileFilter {
    private final String rootDirectoryPath;
    private final String[] includes;
    private final String[] excludes;

    public RegexFileFilter(File directory, String[] includes, String[] excludes) {
        this.rootDirectoryPath = RegexFileFilter.getCanonicalPath(directory);
        this.includes = (String[])includes.clone();
        this.excludes = (String[])excludes.clone();
    }

    public final boolean accept(File dir, String name) {
        return this.isAcceptable(new File(dir, name));
    }

    public final boolean accept(File file) {
        return this.isAcceptable(file);
    }

    protected boolean isAcceptable(File file) {
        String path = RegexFileFilter.getCanonicalPath(file);
        if (!path.startsWith(this.rootDirectoryPath)) {
            return false;
        }
        String nameWithoutRoot = path.substring(this.rootDirectoryPath.length() + 1).replace('\\', '/');
        return !RegexFileFilter.matches(nameWithoutRoot, this.excludes) && RegexFileFilter.matches(nameWithoutRoot, this.includes);
    }

    protected static boolean matches(String path, String[] patterns) {
        for (String pattern : patterns) {
            if (!path.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    protected static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RegexFileFilterException(e);
        }
    }
}

