/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugin.util.io;

import biz.gabrys.maven.plugin.util.io.LoggerUtils;
import biz.gabrys.maven.plugin.util.parameter.ParameterUtils;
import java.io.File;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.plugin.logging.Log;

public class LoggingFileFilter
implements IOFileFilter {
    private final IOFileFilter filter;
    private final Log logger;

    public LoggingFileFilter(IOFileFilter filter, Log logger) {
        ParameterUtils.verifyNotNull("filter", filter);
        ParameterUtils.verifyNotNull("logger", logger);
        this.filter = filter;
        this.logger = logger;
    }

    public boolean accept(File file) {
        boolean accepted = this.filter.accept(file);
        if (!this.logger.isDebugEnabled()) {
            return accepted;
        }
        LoggerUtils.debugInclusion(this.logger, file, accepted);
        return accepted;
    }

    public boolean accept(File dir, String name) {
        boolean accepted = this.filter.accept(dir, name);
        if (!this.logger.isDebugEnabled()) {
            return accepted;
        }
        LoggerUtils.debugInclusion(this.logger, new File(dir, name), accepted);
        return accepted;
    }
}

