/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugin.util.io;

import java.io.File;

public class DestinationFileCreator {
    public static final String FILE_NAME_PARAMETER = "{fileName}";
    private final File sourceDirectory;
    private final File outputDirectory;
    private String fileNamePattern;

    public DestinationFileCreator(File sourceDirectory, File outputDirectory) {
        this.sourceDirectory = sourceDirectory;
        this.outputDirectory = outputDirectory;
    }

    public DestinationFileCreator(File sourceDirectory, File outputDirectory, String fileNamePattern) {
        this.sourceDirectory = sourceDirectory;
        this.outputDirectory = outputDirectory;
        this.fileNamePattern = fileNamePattern;
    }

    public void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
    }

    public File create(File source) {
        String fileName = source.getName();
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            fileName = fileName.substring(0, index);
        }
        fileName = this.fileNamePattern.replace(FILE_NAME_PARAMETER, fileName);
        String parentPath = source.getParentFile().getAbsolutePath();
        String path = parentPath.substring(this.sourceDirectory.getAbsolutePath().length());
        File directory = new File(this.outputDirectory, path);
        return new File(directory, fileName);
    }
}

