/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugin.util.io;

import biz.gabrys.maven.plugin.util.io.FileScanner;
import biz.gabrys.maven.plugin.util.io.LoggingDirectoryScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntFileScanner
implements FileScanner {
    private final Log logger;

    public AntFileScanner() {
        this(null);
    }

    public AntFileScanner(Log logger) {
        this.logger = logger;
    }

    @Override
    public Collection<File> getFiles(File directory, String[] includes, String[] excludes) {
        DirectoryScanner scanner = this.createDirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes((String[])includes.clone());
        scanner.setExcludes((String[])excludes.clone());
        scanner.scan();
        return this.convertToFiles(directory, scanner.getIncludedFiles());
    }

    protected DirectoryScanner createDirectoryScanner() {
        boolean loggerEnabled = this.logger != null && this.logger.isDebugEnabled();
        return loggerEnabled ? new LoggingDirectoryScanner(this.logger) : new DirectoryScanner();
    }

    protected List<File> convertToFiles(File directory, String[] paths) {
        ArrayList<File> files = new ArrayList<File>(paths.length);
        for (String path : paths) {
            files.add(new File(directory, path));
        }
        return files;
    }
}

