/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugin.util.classpath;

import biz.gabrys.maven.plugin.util.parameter.ParameterUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextClassLoaderExtender {
    private final MavenProject project;
    private final Log logger;

    public ContextClassLoaderExtender(MavenProject project, Log logger) {
        ParameterUtils.verifyNotNull("project", project);
        ParameterUtils.verifyNotNull("logger", logger);
        this.project = project;
        this.logger = logger;
    }

    public void addDependencies(String ... types) {
        ParameterUtils.verifyNotNull("types", types);
        this.addDependencies(new HashSet<String>(Arrays.asList(types)));
    }

    public void addDependencies(Collection<String> types) {
        ParameterUtils.verifyNotNull("types", types);
        Set artifacts = this.project.getArtifacts();
        List<Artifact> filtered = this.filterArtifacts(artifacts, types);
        List<URL> urls = this.resolveArtifactsUrls(filtered);
        this.addToContextClassLoader(urls);
    }

    protected List<Artifact> filterArtifacts(Collection<Artifact> artifacts, Collection<String> types) {
        LinkedList<Artifact> filtered = new LinkedList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (types.contains(artifact.getType())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((CharSequence)String.format("Include %s", this.createDisplayText(artifact)));
                }
                filtered.add(artifact);
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((CharSequence)String.format("Exclude %s", this.createDisplayText(artifact)));
        }
        return filtered;
    }

    protected List<URL> resolveArtifactsUrls(Collection<Artifact> artifacts) {
        ArrayList<URL> urls = new ArrayList<URL>(artifacts.size());
        for (Artifact artifact : artifacts) {
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(String.format("Cannot add %s to the classpath!", this.createDisplayText(artifact)), e);
            }
        }
        return urls;
    }

    protected void addToContextClassLoader(List<URL> urls) {
        Thread currentThread = Thread.currentThread();
        URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), currentThread.getContextClassLoader());
        currentThread.setContextClassLoader(classLoader);
    }

    protected String createDisplayText(Artifact artifact) {
        return String.format("%s:%s-%s.%s (%s)", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getScope());
    }
}

