/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.storage;

import biz.gabrys.lesscss.extended.compiler.storage.DataStorage;
import biz.gabrys.lesscss.extended.compiler.storage.DataStorageException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStorageImpl
implements DataStorage {
    private final Object mutex = new Object();
    protected final File workingDirectory;

    public DataStorageImpl(File workingDirectory) {
        if (workingDirectory == null) {
            throw new IllegalArgumentException("Working directory cannot be null");
        }
        this.workingDirectory = workingDirectory;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public boolean hasData(String fileName) {
        return this.getFile(fileName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String fileName, File file) {
        Object object = this.mutex;
        synchronized (object) {
            File cache = this.getFilePreparedForPut(fileName);
            try {
                FileUtils.copyFile((File)file, (File)cache);
            }
            catch (IOException e) {
                throw new DataStorageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFile(String fileName) {
        Object object = this.mutex;
        synchronized (object) {
            File file = new File(this.workingDirectory, fileName);
            if (file.exists()) {
                return file;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String fileName, String text) {
        Object object = this.mutex;
        synchronized (object) {
            File cache = this.getFilePreparedForPut(fileName);
            try {
                FileUtils.write((File)cache, (CharSequence)text);
            }
            catch (IOException e) {
                throw new DataStorageException(e);
            }
        }
    }

    @Override
    public String getText(String fileName) {
        Object object = this.mutex;
        synchronized (object) {
            File cache = this.getFile(fileName);
            if (cache == null) {
                return null;
            }
            try {
                return FileUtils.readFileToString((File)cache);
            }
            catch (IOException e) {
                throw new DataStorageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String fileName, Collection<String> lines) {
        Object object = this.mutex;
        synchronized (object) {
            File cache = this.getFilePreparedForPut(fileName);
            try {
                FileUtils.writeLines((File)cache, lines);
            }
            catch (IOException e) {
                throw new DataStorageException(e);
            }
        }
    }

    @Override
    public List<String> getLines(String fileName) {
        Object object = this.mutex;
        synchronized (object) {
            File cache = this.getFile(fileName);
            if (cache == null) {
                return null;
            }
            try {
                return FileUtils.readLines((File)cache);
            }
            catch (IOException e) {
                throw new DataStorageException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String fileName) {
        Object object = this.mutex;
        synchronized (object) {
            this.getFilePreparedForPut(fileName);
        }
    }

    private File getFilePreparedForPut(String fileName) {
        File file = new File(this.workingDirectory, fileName);
        if (file.exists() && !file.delete()) {
            throw new DataStorageException(String.format("Cannot remove old source file \"%s\"", file));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() {
        Object object = this.mutex;
        synchronized (object) {
            try {
                FileUtils.cleanDirectory((File)this.workingDirectory);
            }
            catch (IOException e) {
                throw new DataStorageException(e);
            }
        }
    }
}

