/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.source;

import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;

public class HttpSource
implements LessSource {
    private static final Collection<Integer> REDIRECT_CODES = new HashSet<Integer>(Arrays.asList(301, 302, 303));
    private final URL url;
    private String encoding;
    private Date lastModificationDate;

    public HttpSource(URL url) {
        this.url = url;
    }

    public String getPath() {
        return this.url.toString();
    }

    public String getEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        HttpURLConnection connection = this.makeConnection(false);
        return HttpSource.getEncodingFromContentType(connection.getContentType());
    }

    private static String getEncodingFromContentType(String contentType) {
        if (contentType == null || !contentType.contains("charset=")) {
            return Charset.defaultCharset().toString();
        }
        return contentType.substring(contentType.lastIndexOf(61) + 1);
    }

    public String getContent() {
        String content;
        HttpURLConnection connection = this.makeConnection(true);
        this.encoding = HttpSource.getEncodingFromContentType(connection.getContentType());
        try {
            content = IOUtils.toString((InputStream)connection.getInputStream(), (String)this.encoding);
        }
        catch (IOException e) {
            connection.disconnect();
            throw new SourceException(String.format("Cannot read content of the \"%s\" file", this.url), e);
        }
        this.lastModificationDate = HttpSource.getModificationDate(connection.getLastModified());
        connection.disconnect();
        return content;
    }

    public Date getLastModificationDate() {
        if (this.lastModificationDate != null) {
            return (Date)this.lastModificationDate.clone();
        }
        HttpURLConnection connection = this.makeConnection(false);
        Date date = HttpSource.getModificationDate(connection.getLastModified());
        connection.disconnect();
        return date;
    }

    private static Date getModificationDate(long modificationDate) {
        if (modificationDate == 0L) {
            return new Date();
        }
        return new Date(modificationDate);
    }

    private HttpURLConnection makeConnection(boolean fetchResponseBody) {
        int responseCode;
        HttpURLConnection connection;
        URL resourceUrl = this.url;
        boolean redirected = false;
        while (true) {
            try {
                connection = (HttpURLConnection)resourceUrl.openConnection();
                connection.setRequestMethod(fetchResponseBody ? "GET" : "HEAD");
                responseCode = connection.getResponseCode();
            }
            catch (IOException e) {
                throw new SourceException(e);
            }
            if (!REDIRECT_CODES.contains(responseCode)) break;
            redirected = true;
            String location = connection.getHeaderField("Location");
            try {
                resourceUrl = new URL(location);
            }
            catch (MalformedURLException e) {
                throw new SourceException(String.format("Invalid \"Location\" header: %s", location), e);
            }
        }
        if (responseCode != 200) {
            throw new SourceException(this.createDownloadErrorMessage(resourceUrl, redirected, responseCode));
        }
        return connection;
    }

    private String createDownloadErrorMessage(URL resourceUrl, boolean redirected, int responseCode) {
        String redirectedText = "";
        if (redirected) {
            redirectedText = String.format("redirected from \"%s\", ", this.url);
        }
        throw new SourceException(String.format("Cannot download source \"%s\" (%serror code: %s)", resourceUrl, redirectedText, responseCode));
    }
}

