/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.source;

import biz.gabrys.lesscss.extended.compiler.source.ConcreteSourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactoryException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUriSourceFactory<T extends LessSource>
implements ConcreteSourceFactory<T> {
    protected AbstractUriSourceFactory() {
    }

    @Override
    public T createAbsoluteSource(LessSource source, String importAbsolutePath) {
        try {
            URI importUri = new URI(importAbsolutePath).normalize();
            return this.createSource(importUri, source.getEncoding());
        }
        catch (Exception e) {
            throw new SourceFactoryException("Cannot create absoulte source", e);
        }
    }

    @Override
    public T createRelativeSource(LessSource source, String importRelativePath) {
        try {
            String sourcePath = source.getPath();
            String parentPath = sourcePath.substring(0, sourcePath.lastIndexOf(47));
            URI importUri = new URI(parentPath + '/' + importRelativePath).normalize();
            return this.createSource(importUri, source.getEncoding());
        }
        catch (Exception e) {
            throw new SourceFactoryException("Cannot create relative source", e);
        }
    }

    protected abstract T createSource(URI var1, String var2) throws Exception;

    @Override
    public boolean isAbsolutePath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return this.isSupportedPath(path);
    }

    protected abstract boolean isSupportedPath(String var1);
}

