/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.imports;

import biz.gabrys.lesscss.extended.compiler.imports.ImportException;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportOperation;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessImportResolverImpl
implements LessImportResolver {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("@import\\s+(\\(([a-z]+)\\))?\\s*((\"([^\"]+)\")|('([^']+)'))\\s*;", 8);
    private static final int SOURCE_CODE_GROUP_INDEX = 0;
    private static final int IMPORT_OPTION_GROUP_INDEX = 2;
    private static final int PATH_IN_DOUBLE_QUOTES_GROUP_INDEX = 5;
    private static final int PATH_IN_SINGLE_QUOTES_GROUP_INDEX = 7;

    @Override
    public List<LessImportOperation> resolve(String sourceCode) {
        ArrayList<LessImportOperation> imports = new ArrayList<LessImportOperation>();
        Matcher matcher = IMPORT_PATTERN.matcher(sourceCode);
        while (matcher.find()) {
            String path = LessImportResolverImpl.resolvePath(matcher);
            String option = matcher.group(2);
            String computedPath = path;
            String computedOption = option;
            if (option == null) {
                computedPath = computedPath.matches(".*\\.[^.\\s]+$") ? computedPath : computedPath + ".less";
                String string = computedOption = computedPath.endsWith(".css") ? "css" : "less";
            }
            if ("css".equals(computedOption)) continue;
            imports.add(new LessImportOperation(path, computedPath, option, computedOption, matcher.group(0)));
        }
        return imports;
    }

    private static String resolvePath(MatchResult matchResult) {
        String path = matchResult.group(5);
        if (path == null) {
            path = matchResult.group(7);
        }
        if (path.contains("'") || path.contains("\"")) {
            String characterInfo = path.contains("'") ? "' (apostrophe)" : "\" (quote)";
            throw new ImportException(String.format("Path contains not allowed character: %s", characterInfo));
        }
        return path;
    }
}

