/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.imports;

import biz.gabrys.lesscss.extended.compiler.imports.ImportException;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportOperation;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportReplacer;

public class LessImportReplacerImpl
implements LessImportReplacer {
    public String replace(String sourceCode, LessImportOperation operation, String importPath) {
        String importSourceCode = operation.getSourceCode();
        int importIndex = sourceCode.indexOf(importSourceCode);
        if (importIndex < 0) {
            throw new ImportException(String.format("Source code does not contain \"%s\"", importSourceCode));
        }
        String beginCode = sourceCode.substring(0, importIndex);
        String endCode = sourceCode.substring(importIndex + importSourceCode.length());
        StringBuilder newImportSourceCode = new StringBuilder(importPath.length() + 25);
        newImportSourceCode.append("@import (");
        newImportSourceCode.append(operation.getComputedOption());
        newImportSourceCode.append(") \"");
        newImportSourceCode.append(importPath);
        newImportSourceCode.append("\";");
        return beginCode + newImportSourceCode + endCode;
    }
}

