/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.control.processor;

import biz.gabrys.lesscss.extended.compiler.cache.SourceCodeCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceImportsCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceModificationDateCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.processor.AbstractSourceTreePreparationProcessor;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportOperation;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportReplacer;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolver;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceTreeWithCodeCachingPreparationProcessor
extends AbstractSourceTreePreparationProcessor {
    protected SourceModificationDateCache datesCache;
    protected SourceCodeCache codeCache;
    protected LessImportResolver importResolver;
    protected LessImportReplacer importReplacer;

    public SourceTreeWithCodeCachingPreparationProcessor(SourceExpirationChecker expirationChecker, SourceModificationDateCache datesCache, SourceImportsCache importsCache, SourceCodeCache codeCache, LessImportResolver importResolver, LessImportReplacer importReplacer, SourceFactory sourceFactory) {
        super(expirationChecker, importsCache, sourceFactory);
        this.datesCache = datesCache;
        this.codeCache = codeCache;
        this.importResolver = importResolver;
        this.importReplacer = importReplacer;
    }

    @Override
    protected void prepareWhenExpired(LessSource source, Set<String> preparedSourcesPaths) {
        String sourceCode = source.getContent();
        this.datesCache.saveSourceModificationDate(source, source.getLastModificationDate());
        List<LessImportOperation> operations = this.importResolver.resolve(sourceCode);
        ArrayList<String> imports = new ArrayList<String>(operations.size());
        for (LessImportOperation operation : operations) {
            LessSource importSource = this.sourceFactory.create(source, operation.getComputedPath());
            imports.add(operation.getComputedPath());
            this.prepare(importSource, preparedSourcesPaths);
            String importedPath = this.codeCache.getSourceRelativePath(importSource);
            sourceCode = this.importReplacer.replace(sourceCode, operation, importedPath);
        }
        this.importsCache.saveSourceImports(source, imports);
        this.codeCache.saveSourceCode(source, sourceCode);
    }
}

