/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.cache;

import biz.gabrys.lesscss.extended.compiler.cache.FullCacheImpl;
import biz.gabrys.lesscss.extended.compiler.cache.TemporaryDirectoryUtils;
import biz.gabrys.lesscss.extended.compiler.storage.DataStorage;
import biz.gabrys.lesscss.extended.compiler.storage.DataStorageImpl;
import biz.gabrys.lesscss.extended.compiler.util.ParameterUtils;
import java.io.File;
import java.io.IOException;

public class FullCacheBuilder {
    private DataStorage dataStorage;

    public FullCacheBuilder withDirectory(File workingDirectory) {
        ParameterUtils.verifyNotNull("directory", workingDirectory);
        this.dataStorage = new DataStorageImpl(workingDirectory);
        return this;
    }

    public FullCacheBuilder withDataStorage(DataStorage dataStorage) {
        ParameterUtils.verifyNotNull("data storage", dataStorage);
        this.dataStorage = dataStorage;
        return this;
    }

    public FullCacheImpl create() {
        if (this.dataStorage == null) {
            this.dataStorage = this.createFallbackDataStorage();
        }
        return new FullCacheImpl(this.dataStorage);
    }

    protected DataStorage createFallbackDataStorage() {
        try {
            return new DataStorageImpl(TemporaryDirectoryUtils.create());
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Cannot create temporary directory", e);
        }
    }
}

