/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.cache;

import biz.gabrys.lesscss.extended.compiler.cache.CompilationDateCache;
import biz.gabrys.lesscss.extended.compiler.cache.CompiledCodeCache;
import biz.gabrys.lesscss.extended.compiler.cache.FullCache;
import biz.gabrys.lesscss.extended.compiler.cache.FullCacheAdapter;
import biz.gabrys.lesscss.extended.compiler.cache.SourceCodeCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceImportsCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceModificationDateCache;
import biz.gabrys.lesscss.extended.compiler.util.ParameterUtils;

public class FullCacheAdapterBuilder {
    private SourceModificationDateCache modificationDatesCache;
    private SourceImportsCache importsCache;
    private SourceCodeCache sourceCache;
    private CompilationDateCache compilationDatesCache;
    private CompiledCodeCache compiledCache;

    public FullCacheAdapterBuilder(FullCache cache) {
        ParameterUtils.verifyNotNull("full cache", cache);
        this.modificationDatesCache = cache;
        this.importsCache = cache;
        this.sourceCache = cache;
        this.compilationDatesCache = cache;
        this.compiledCache = cache;
    }

    public FullCacheAdapterBuilder withSourceModificationDateCache(SourceModificationDateCache cache) {
        ParameterUtils.verifyNotNull("source modification dates", cache);
        this.modificationDatesCache = cache;
        return this;
    }

    public FullCacheAdapterBuilder withSourceImportsPathsCache(SourceImportsCache cache) {
        ParameterUtils.verifyNotNull("source imports paths", cache);
        this.importsCache = cache;
        return this;
    }

    public FullCacheAdapterBuilder withSourceCodeCache(SourceCodeCache cache) {
        ParameterUtils.verifyNotNull("source code cache", cache);
        this.sourceCache = cache;
        return this;
    }

    public FullCacheAdapterBuilder withCompilationDateCache(CompilationDateCache cache) {
        ParameterUtils.verifyNotNull("compilation dates cache", cache);
        this.compilationDatesCache = cache;
        return this;
    }

    public FullCacheAdapterBuilder withCompiledCodeCache(CompiledCodeCache cache) {
        ParameterUtils.verifyNotNull("compiled code cache", cache);
        this.compiledCache = cache;
        return this;
    }

    public FullCacheAdapter create() {
        return new FullCacheAdapter(this.modificationDatesCache, this.importsCache, this.sourceCache, this.compilationDatesCache, this.compiledCache);
    }
}

