/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler.cache;

import biz.gabrys.lesscss.extended.compiler.cache.CompilationDateCache;
import biz.gabrys.lesscss.extended.compiler.cache.CompiledCodeCache;
import biz.gabrys.lesscss.extended.compiler.cache.FullCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceCodeCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceImportsCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceModificationDateCache;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.util.ParameterUtils;
import java.io.File;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullCacheAdapter
implements FullCache {
    protected SourceModificationDateCache modificationDatesCache;
    protected SourceImportsCache importsCache;
    protected SourceCodeCache sourceCache;
    protected CompilationDateCache compilationDatesCache;
    protected CompiledCodeCache compiledCache;

    public FullCacheAdapter(SourceModificationDateCache modificationDatesCache, SourceImportsCache importsCache, SourceCodeCache sourceCache, CompilationDateCache compilationDatesCache, CompiledCodeCache compiledCache) {
        ParameterUtils.verifyNotNull("source modification dates cache", modificationDatesCache);
        ParameterUtils.verifyNotNull("source imports paths cache", importsCache);
        ParameterUtils.verifyNotNull("source code cache", sourceCache);
        ParameterUtils.verifyNotNull("compilation dates cache", compilationDatesCache);
        ParameterUtils.verifyNotNull("compiled code cache", compiledCache);
        this.modificationDatesCache = modificationDatesCache;
        this.importsCache = importsCache;
        this.sourceCache = sourceCache;
        this.compilationDatesCache = compilationDatesCache;
        this.compiledCache = compiledCache;
    }

    @Override
    public void saveSourceModificationDate(LessSource source, Date modificationDate) {
        this.modificationDatesCache.saveSourceModificationDate(source, modificationDate);
    }

    @Override
    public boolean hasSourceModificationDate(LessSource source) {
        return this.modificationDatesCache.hasSourceModificationDate(source);
    }

    @Override
    public Date getSourceModificationDate(LessSource source) {
        return this.modificationDatesCache.getSourceModificationDate(source);
    }

    @Override
    public void saveSourceImports(LessSource source, List<String> imports) {
        this.importsCache.saveSourceImports(source, imports);
    }

    @Override
    public boolean hasSourceImports(LessSource source) {
        return this.importsCache.hasSourceImports(source);
    }

    @Override
    public List<String> getSourceImports(LessSource source) {
        return this.importsCache.getSourceImports(source);
    }

    @Override
    public void saveSourceCode(LessSource source, String sourceCode) {
        this.sourceCache.saveSourceCode(source, sourceCode);
    }

    @Override
    public boolean hasSourceCode(LessSource source) {
        return this.sourceCache.hasSourceCode(source);
    }

    @Override
    public File getSourceFile(LessSource source) {
        return this.sourceCache.getSourceFile(source);
    }

    @Override
    public String getSourceRelativePath(LessSource source) {
        return this.sourceCache.getSourceRelativePath(source);
    }

    @Override
    public void saveCompilationDate(LessSource source, Date compilationDate) {
        this.compilationDatesCache.saveCompilationDate(source, compilationDate);
    }

    @Override
    public boolean hasCompilationDate(LessSource source) {
        return this.compilationDatesCache.hasCompilationDate(source);
    }

    @Override
    public Date getCompilationDate(LessSource source) {
        return this.compilationDatesCache.getCompilationDate(source);
    }

    @Override
    public void saveCompiledCode(LessSource source, String compiledCode) {
        this.compiledCache.saveCompiledCode(source, compiledCode);
    }

    @Override
    public boolean hasCompiledCode(LessSource source) {
        return this.compiledCache.hasCompiledCode(source);
    }

    @Override
    public String getCompiledCode(LessSource source) {
        return this.compiledCache.getCompiledCode(source);
    }
}

