/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler;

import biz.gabrys.lesscss.compiler.LessCompiler;
import biz.gabrys.lesscss.compiler.LessCompilerImpl;
import biz.gabrys.lesscss.extended.compiler.ExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.SimpleExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.cache.FullCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceModificationDateBasedExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.processor.DoNothingPostCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.PostCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.PreCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.control.processor.SourceTreeWithCodeCachingPreparationProcessorBuilder;
import biz.gabrys.lesscss.extended.compiler.control.provider.CachedSourceFileProvider;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportReplacer;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportReplacerImpl;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolver;
import biz.gabrys.lesscss.extended.compiler.imports.LessImportResolverImpl;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactoryBuilder;
import biz.gabrys.lesscss.extended.compiler.util.ParameterUtils;

public class CachingSourceCodeExtendedCompilerBuilder {
    private final FullCache cache;
    private LessCompiler compiler;
    private SourceExpirationChecker expirationChecker;
    private LessImportResolver importResolver;
    private LessImportReplacer importReplacer;
    private SourceFactory sourceFactory;
    private PostCompilationProcessor postProcessor;

    public CachingSourceCodeExtendedCompilerBuilder(FullCache cache) {
        ParameterUtils.verifyNotNull("cache", cache);
        this.cache = cache;
    }

    public CachingSourceCodeExtendedCompilerBuilder withCompiler(LessCompiler compiler) {
        this.compiler = compiler;
        return this;
    }

    public CachingSourceCodeExtendedCompilerBuilder withExpirationChecker(SourceExpirationChecker expirationChecker) {
        this.expirationChecker = expirationChecker;
        return this;
    }

    public CachingSourceCodeExtendedCompilerBuilder withImportResolver(LessImportResolver importResolver) {
        this.importResolver = importResolver;
        return this;
    }

    public CachingSourceCodeExtendedCompilerBuilder withImportReplacer(LessImportReplacer importReplacer) {
        this.importReplacer = importReplacer;
        return this;
    }

    public CachingSourceCodeExtendedCompilerBuilder withSourceFactory(SourceFactory sourceFactory) {
        this.sourceFactory = sourceFactory;
        return this;
    }

    public CachingSourceCodeExtendedCompilerBuilder withPostProcessor(PostCompilationProcessor postProcessor) {
        this.postProcessor = postProcessor;
        return this;
    }

    public ExtendedCompiler create() {
        LessCompiler lessCompiler = this.compiler != null ? this.compiler : new LessCompilerImpl();
        PreCompilationProcessor preProc = this.createPreProcessor(new SourceTreeWithCodeCachingPreparationProcessorBuilder(this.cache));
        PostCompilationProcessor postProc = this.postProcessor != null ? this.postProcessor : new DoNothingPostCompilationProcessor();
        return new SimpleExtendedCompiler(lessCompiler, preProc, new CachedSourceFileProvider(this.cache), postProc);
    }

    PreCompilationProcessor createPreProcessor(SourceTreeWithCodeCachingPreparationProcessorBuilder builder) {
        builder.withExpirationChecker(this.expirationChecker != null ? this.expirationChecker : new SourceModificationDateBasedExpirationChecker(this.cache));
        builder.withImportResolver(this.importResolver != null ? this.importResolver : new LessImportResolverImpl());
        builder.withImportReplacer(this.importReplacer != null ? this.importReplacer : new LessImportReplacerImpl());
        builder.withSourceFactory(this.createSourceFactory());
        return builder.create();
    }

    SourceFactory createSourceFactory() {
        return this.sourceFactory != null ? this.sourceFactory : this.createSourceFactoryFromBuilder(new SourceFactoryBuilder());
    }

    SourceFactory createSourceFactoryFromBuilder(SourceFactoryBuilder builder) {
        return builder.withStandard().create();
    }
}

