/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.extended.compiler;

import biz.gabrys.lesscss.compiler.CompilerException;
import biz.gabrys.lesscss.compiler.CompilerOptions;
import biz.gabrys.lesscss.extended.compiler.ExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.cache.CompilationDateCache;
import biz.gabrys.lesscss.extended.compiler.cache.CompiledCodeCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.CompiledSourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import java.util.Date;

public class CachingCompiledCodeExtendedCompiler
implements ExtendedCompiler {
    protected ExtendedCompiler compiler;
    protected CompiledSourceExpirationChecker expirationChecker;
    protected CompilationDateCache datesCache;
    protected CompiledCodeCache codeCache;

    public CachingCompiledCodeExtendedCompiler(ExtendedCompiler compiler, CompiledSourceExpirationChecker expirationChecker, CompilationDateCache datesCache, CompiledCodeCache codeCache) {
        this.compiler = compiler;
        this.expirationChecker = expirationChecker;
        this.datesCache = datesCache;
        this.codeCache = codeCache;
    }

    public String compile(LessSource source) throws CompilerException {
        if (this.isExpired(source)) {
            String compiledCode = this.compiler.compile(source);
            this.datesCache.saveCompilationDate(source, new Date());
            this.codeCache.saveCompiledCode(source, compiledCode);
            return compiledCode;
        }
        return this.codeCache.getCompiledCode(source);
    }

    public String compile(LessSource source, CompilerOptions options) throws CompilerException {
        if (this.isExpired(source)) {
            String compiledCode = this.compiler.compile(source, options);
            this.datesCache.saveCompilationDate(source, new Date());
            this.codeCache.saveCompiledCode(source, compiledCode);
            return compiledCode;
        }
        return this.codeCache.getCompiledCode(source);
    }

    protected boolean isExpired(LessSource source) {
        if (!this.datesCache.hasCompilationDate(source)) {
            return true;
        }
        Date compilationDate = this.datesCache.getCompilationDate(source);
        return this.expirationChecker.isExpired(source, compilationDate);
    }
}

