/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.lesscss.compiler;

import biz.gabrys.lesscss.compiler.CompilerOptions;
import biz.gabrys.lesscss.compiler.ListWithoutEmptyValuesBuilder;
import biz.gabrys.lesscss.compiler.OperatingSystemChecker;
import biz.gabrys.lesscss.compiler.OperatingSystemCheckerImpl;
import biz.gabrys.lesscss.compiler.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerOptionsBuilder {
    private final OperatingSystemChecker systemChecker;
    private boolean ieCompatability = true;
    private List<String> includePaths = new ArrayList<String>();
    private boolean minified;
    private boolean relativeUrls;
    private String rootPath = "";
    private boolean strictImports;
    private boolean strictMath;
    private boolean strictUnits;
    private String urlsArgument = "";

    public CompilerOptionsBuilder() {
        this.systemChecker = new OperatingSystemCheckerImpl();
    }

    public CompilerOptionsBuilder(OperatingSystemChecker systemChecker) {
        this.systemChecker = systemChecker;
    }

    public boolean isIeCompatability() {
        return this.ieCompatability;
    }

    public CompilerOptionsBuilder setIeCompatability(boolean ieCompatability) {
        this.ieCompatability = ieCompatability;
        return this;
    }

    protected String getIeCompatabilityCompilerArgument() {
        if (this.ieCompatability) {
            return "";
        }
        return "--no-ie-compat";
    }

    public List<String> getIncludePaths() {
        return new ArrayList<String>(this.includePaths);
    }

    public CompilerOptionsBuilder setIncludePaths(List<String> includePaths) {
        this.includePaths = includePaths == null || includePaths.isEmpty() ? Collections.emptyList() : new ArrayList<String>(includePaths);
        return this;
    }

    protected String getIncludePathsCompilerArgument() {
        if (this.includePaths == null || this.includePaths.isEmpty()) {
            return "";
        }
        StringBuilder paths = new StringBuilder();
        for (String path : this.includePaths) {
            boolean separatorRequired;
            if (!StringUtils.isNotBlank(path)) continue;
            boolean bl = separatorRequired = paths.length() != 0;
            if (separatorRequired) {
                paths.append(this.systemChecker.isWindows() ? (char)';' : ':');
            }
            paths.append(path.trim());
        }
        return "--include-path=" + paths.toString();
    }

    public boolean isMinified() {
        return this.minified;
    }

    public CompilerOptionsBuilder setMinified(boolean minified) {
        this.minified = minified;
        return this;
    }

    protected String getMinifiedCompilerArgument() {
        if (this.minified) {
            return "-x";
        }
        return "";
    }

    public boolean isRelativeUrls() {
        return this.relativeUrls;
    }

    public CompilerOptionsBuilder setRelativeUrls(boolean relativeUrls) {
        this.relativeUrls = relativeUrls;
        return this;
    }

    protected String getRelativeUrlsCompilerArgument() {
        if (this.relativeUrls) {
            return "--relative-urls";
        }
        return "";
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public CompilerOptionsBuilder setRootPath(String rootPath) {
        this.rootPath = rootPath;
        return this;
    }

    protected String getRootPathCompilerArgument() {
        if (StringUtils.isNotBlank(this.rootPath)) {
            return "--rootpath=" + this.rootPath.trim();
        }
        return "";
    }

    public boolean isStrictImports() {
        return this.strictImports;
    }

    public CompilerOptionsBuilder setStrictImports(boolean strictImports) {
        this.strictImports = strictImports;
        return this;
    }

    protected String getStrictImportsCompilerArgument() {
        if (this.strictImports) {
            return "--strict-imports";
        }
        return "";
    }

    public boolean isStrictMath() {
        return this.strictMath;
    }

    public CompilerOptionsBuilder setStrictMath(boolean strictMath) {
        this.strictMath = strictMath;
        return this;
    }

    protected String getStrictMathCompilerArgument() {
        if (this.strictMath) {
            return "--strict-math=on";
        }
        return "--strict-math=off";
    }

    public boolean isStrictUnits() {
        return this.strictUnits;
    }

    public CompilerOptionsBuilder setStrictUnits(boolean strictUnits) {
        this.strictUnits = strictUnits;
        return this;
    }

    protected String getStrictUnitsCompilerArgument() {
        if (this.strictUnits) {
            return "--strict-units=on";
        }
        return "--strict-units=off";
    }

    public String getUrlsArgument() {
        return this.urlsArgument;
    }

    public CompilerOptionsBuilder setUrlsArgument(String urlsArgument) {
        this.urlsArgument = urlsArgument;
        return this;
    }

    protected String getUrlsArgumentCompilerArgument() {
        if (StringUtils.isNotBlank(this.urlsArgument)) {
            return String.format("--url-args=\"%s\"", this.urlsArgument.trim().replace("\"", "\\\""));
        }
        return "";
    }

    public CompilerOptions create() {
        ListWithoutEmptyValuesBuilder arguments = new ListWithoutEmptyValuesBuilder();
        arguments.add(this.getIeCompatabilityCompilerArgument());
        arguments.add(this.getIncludePathsCompilerArgument());
        arguments.add(this.getMinifiedCompilerArgument());
        arguments.add(this.getRelativeUrlsCompilerArgument());
        arguments.add(this.getRootPathCompilerArgument());
        arguments.add(this.getStrictImportsCompilerArgument());
        arguments.add(this.getStrictMathCompilerArgument());
        arguments.add(this.getStrictUnitsCompilerArgument());
        arguments.add(this.getUrlsArgumentCompilerArgument());
        return new CompilerOptions(arguments.create());
    }
}

