package aQute.lib.osgi;

import java.util.*;
import java.util.regex.*;

public interface Constants {
    public final static String   BUNDLE_CLASSPATH                    = "Bundle-ClassPath";
    public final static String   BUNDLE_COPYRIGHT                    = "Bundle-Copyright";
    public final static String   BUNDLE_DESCRIPTION                  = "Bundle-Description";
    public final static String   BUNDLE_NAME                         = "Bundle-Name";
    public final static String   BUNDLE_NATIVECODE                   = "Bundle-NativeCode";
    public final static String   EXPORT_PACKAGE                      = "Export-Package";
    public final static String   EXPORT_SERVICE                      = "Export-Service";
    public final static String   IMPORT_PACKAGE                      = "Import-Package";
    public final static String   DYNAMICIMPORT_PACKAGE               = "DynamicImport-Package";
    public final static String   IMPORT_SERVICE                      = "Import-Service";
    public final static String   BUNDLE_VENDOR                       = "Bundle-Vendor";
    public final static String   BUNDLE_VERSION                      = "Bundle-Version";
    public final static String   BUNDLE_DOCURL                       = "Bundle-DocURL";
    public final static String   BUNDLE_CONTACTADDRESS               = "Bundle-ContactAddress";
    public final static String   BUNDLE_ACTIVATOR                    = "Bundle-Activator";
    public final static String   BUNDLE_REQUIREDEXECUTIONENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    public final static String   BUNDLE_SYMBOLICNAME                 = "Bundle-SymbolicName";
    public final static String   BUNDLE_LOCALIZATION                 = "Bundle-Localization";
    public final static String   REQUIRE_BUNDLE                      = "Require-Bundle";
    public final static String   FRAGMENT_HOST                       = "Fragment-Host";
    public final static String   BUNDLE_MANIFESTVERSION              = "Bundle-ManifestVersion";
    public final static String   SERVICE_COMPONENT                   = "Service-Component";
    public final static String   BUNDLE_LICENSE                      = "Bundle-License";
    public static final String   PRIVATE_PACKAGE                     = "Private-Package";
    public static final String   IGNORE_PACKAGE                      = "Ignore-Package";
    public static final String   INCLUDE_RESOURCE                    = "Include-Resource";
    public static final String   CONDITIONAL_PACKAGE                 = "Conditional-Package";
    public static final String   BND_LASTMODIFIED                    = "Bnd-LastModified";
    public static final String   CREATED_BY                          = "Created-By";
    public static final String   TOOL                                = "Tool";

    public final static String   headers[]                           = {
            BUNDLE_ACTIVATOR, BUNDLE_CONTACTADDRESS, BUNDLE_COPYRIGHT,
            BUNDLE_DESCRIPTION, BUNDLE_DOCURL, BUNDLE_LOCALIZATION,
            BUNDLE_NATIVECODE, BUNDLE_VENDOR, BUNDLE_VERSION, BUNDLE_LICENSE,
            BUNDLE_CLASSPATH, SERVICE_COMPONENT, EXPORT_PACKAGE,
            IMPORT_PACKAGE, BUNDLE_LOCALIZATION, BUNDLE_MANIFESTVERSION,
            BUNDLE_NAME, BUNDLE_NATIVECODE,
            BUNDLE_REQUIREDEXECUTIONENVIRONMENT, BUNDLE_SYMBOLICNAME,
            BUNDLE_VERSION, FRAGMENT_HOST, PRIVATE_PACKAGE, IGNORE_PACKAGE,
            INCLUDE_RESOURCE, REQUIRE_BUNDLE, IMPORT_SERVICE, EXPORT_SERVICE,
            CONDITIONAL_PACKAGE, BND_LASTMODIFIED                   };

    public static final String   CONDUIT                             = "-conduit";
    public static final String   REMOVE_HEADERS                      = "-removeheaders";
    public static final String   SOURCES                             = "-sources";
    public static final String   FAIL_OK                             = "-failok";
    public static final String   DONOTCOPY                           = "-donotcopy";
    public static final String   EXPORT_CONTENTS                     = "-exportcontents";
    public static final String   CLASSPATH                           = "-classpath";
    public static final String   SOURCEPATH                          = "-sourcepath";
    public static final String   PEDANTIC                            = "-pedantic";
    public static final String   NOEXTRAHEADERS                      = "-noextraheaders";
    public static final String   POM                                 = "-pom";
    public static final String   INCLUDE                             = "-include";
    public static final String   NOUSES                              = "-nouses";
    public static final String   RESOURCEONLY                        = "-resourceonly";
    public static final String   MANIFEST                            = "-manifest";
    public static final String   MAKE                                = "-make";
    public static final String   PLUGIN                              = "-plugin";
    public static final String   SUB                                 = "-sub";
    public static final String   NOPE                                = "-nope";

    public static final String   DUPLICATE_MARKER                    = "~";

    public static final String   options[]                           = {
            REMOVE_HEADERS, SOURCES, FAIL_OK, DONOTCOPY, EXPORT_CONTENTS,
            CLASSPATH, PEDANTIC, NOEXTRAHEADERS, POM, INCLUDE, NOUSES,
            RESOURCEONLY, SOURCEPATH, CONDUIT, MANIFEST, MAKE, PLUGIN };

    public static final String   SPLIT_PACKAGE_DIRECTIVE             = "-split-package:";
    public static final String   NO_IMPORT_DIRECTIVE                 = "-noimport:";

    public static final String   directives[]                        = {
            SPLIT_PACKAGE_DIRECTIVE, NO_IMPORT_DIRECTIVE, "resolution:",
            "include:", "uses:", "exclude:",
                                                                     // TODO
                                                                     };
    public static final String[] componentDirectives                 = new String[] {
            "factory:", "immediate:", "enabled:", "dynamic:", "multiple:",
            "provide:", "optional:", "properties:"                  };

    // static Map EES = new HashMap();
    static Set<String>           SET_COMPONENT_DIRECTIVES            = new HashSet<String>(
                                                                             Arrays
                                                                                     .asList(componentDirectives));

    static final Pattern         VALID_PROPERTY_TYPES                = Pattern
                                                                             .compile("(String|Long|Double|Float|Integer|Byte|Character|Boolean|Short)");

}
