/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.export.plugin;

import aQute.bnd.maven.lib.configuration.Bndruns;
import aQute.bnd.maven.lib.configuration.Bundles;
import aQute.bnd.maven.lib.resolve.BndrunContainer;
import aQute.bnd.maven.lib.resolve.Operation;
import aQute.bnd.maven.lib.resolve.Scope;
import aQute.bnd.osgi.JarResource;
import aQute.bnd.osgi.Resource;
import aQute.lib.io.IO;
import biz.aQute.resolve.Bndrun;
import biz.aQute.resolve.ResolveProcess;
import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.osgi.service.resolver.ResolutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="export", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ExportMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(ExportMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySession;
    @Parameter
    private Bndruns bndruns = new Bndruns();
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter
    private Bundles bundles = new Bundles();
    @Parameter(defaultValue="true")
    private boolean useMavenDependencies;
    @Parameter(defaultValue="false")
    private boolean resolve;
    @Parameter(defaultValue="true")
    private boolean reportOptional;
    @Parameter(defaultValue="true")
    private boolean failOnChanges;
    @Parameter(defaultValue="false")
    private boolean bundlesOnly;
    @Parameter
    private String exporter;
    @Parameter(defaultValue="true")
    private boolean attach;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="bnd.export.scopes", defaultValue="compile,runtime")
    private Set<Scope> scopes = new HashSet<Scope>(Arrays.asList(Scope.compile, Scope.runtime));
    @Parameter(property="bnd.export.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="bnd.export.include.dependency.management", defaultValue="false")
    private boolean includeDependencyManagement;
    @Component
    private RepositorySystem system;
    @Component
    private ProjectDependenciesResolver resolver;
    @Component
    protected ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            logger.debug("skip project as configured");
            return;
        }
        int errors = 0;
        try {
            BndrunContainer container = new BndrunContainer.Builder(this.project, this.session, this.repositorySession, this.resolver, this.artifactFactory, this.system).setBundles(this.bundles.getFiles(this.project.getBasedir(), new String[0])).setIncludeDependencyManagement(this.includeDependencyManagement).setScopes(this.scopes).setUseMavenDependencies(this.useMavenDependencies).build();
            Operation operation = this.getOperation();
            for (File runFile : this.bndruns.getFiles(this.project.getBasedir(), new String[]{"*.bndrun"})) {
                errors += container.execute(runFile, "export", this.targetDir, operation);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (errors > 0) {
            throw new MojoFailureException(errors + " errors found");
        }
    }

    private Operation getOperation() {
        return (file, bndrun, run) -> {
            Map.Entry export;
            if (this.resolve) {
                try {
                    String runBundles = run.resolve(this.failOnChanges, false);
                    if (run.isOk()) {
                        run.setProperty("-runbundles", runBundles);
                    }
                }
                catch (ResolutionException re) {
                    logger.error(ResolveProcess.format((ResolutionException)re, (boolean)this.reportOptional));
                    throw re;
                }
                finally {
                    int errors = BndrunContainer.report((Bndrun)run);
                    if (errors > 0) {
                        return errors;
                    }
                }
            }
            if (this.exporter == null) {
                String string = this.exporter = this.bundlesOnly ? "bnd.runbundles" : "bnd.executablejar";
            }
            if ((export = run.export(this.exporter, Collections.emptyMap())) != null) {
                if (this.exporter.equals("bnd.runbundles")) {
                    try (JarResource r = (JarResource)export.getValue();){
                        File runbundlesDir = this.targetDir.toPath().resolve("export").resolve(bndrun).toFile();
                        r.getJar().writeFolder(runbundlesDir);
                    }
                }
                try (Resource r = (Resource)export.getValue();){
                    File exported = IO.getBasedFile((File)this.targetDir, (String)((String)export.getKey()));
                    try (OutputStream out = IO.outputStream((File)exported);){
                        r.write(out);
                    }
                    exported.setLastModified(r.lastModified());
                    this.attach(exported, bndrun);
                }
            }
            return 0;
        };
    }

    private void attach(File file, String classifier) {
        if (!this.attach) {
            logger.debug("The export plugin has been configured not to attach the generated application to the project.");
            return;
        }
        if (!file.getName().endsWith(".jar")) {
            logger.debug("The export plugin will not attach a non-jar output to the project.");
            return;
        }
        DefaultArtifactHandler handler = new DefaultArtifactHandler("jar");
        handler.setExtension("jar");
        DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, "jar", classifier, (ArtifactHandler)handler);
        artifact.setFile(file);
        this.project.addAttachedArtifact((Artifact)artifact);
    }
}

