/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.export.plugin;

import aQute.bnd.build.Project;
import aQute.bnd.build.Run;
import aQute.bnd.maven.export.plugin.StandaloneRun;
import aQute.bnd.osgi.Jar;
import biz.aQute.resolve.ProjectResolver;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="export", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ExportMojo
extends AbstractMojo {
    @Parameter(readonly=true, required=true)
    private List<File> bndruns;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDir;
    @Parameter(readonly=true, required=false)
    private boolean resolve = false;
    @Parameter(readonly=true, required=false)
    private boolean failOnChanges = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            for (File runFile : this.bndruns) {
                if (!runFile.exists()) {
                    throw new MojoExecutionException("Could not find bnd run file " + runFile);
                }
                StandaloneRun run = new StandaloneRun(runFile);
                Throwable throwable = null;
                try {
                    if (this.resolve) {
                        this.resolve(run);
                    }
                    this.export(run);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (run == null) continue;
                    if (throwable != null) {
                        try {
                            run.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    run.close();
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void export(Run run) throws Exception {
        try (Jar jar = run.getProjectLauncher().executable();){
            this.targetDir.mkdirs();
            File jarFile = new File(this.targetDir, this.getNamePart(run.getPropertiesFile()) + ".jar");
            jar.write(jarFile);
        }
    }

    private void resolve(StandaloneRun run) throws Exception, IOException {
        try (ProjectResolver projectResolver = new ProjectResolver((Project)run);){
            List runBundles = projectResolver.getRunBundles();
            Collection currentRunBundles = run.getRunbundles();
            if (!CollectionUtils.isEqualCollection((Collection)currentRunBundles, (Collection)runBundles)) {
                if (this.failOnChanges) {
                    throw new MojoExecutionException("The runbundles have changed. Failing the build");
                }
                this.getLog().warn((CharSequence)"The runbundles have changed. Please check the results of this build.");
                run.setRunBundles(runBundles);
            }
        }
    }

    private String getNamePart(File runFile) {
        String nameExt = runFile.getName();
        int pos = nameExt.lastIndexOf(".");
        return nameExt.substring(0, pos);
    }
}

