/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview.playbackspeed;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.widget.PopupMenu;
import bg.devlabs.fullscreenvideoview.playbackspeed.OnPlaybackSpeedSelectedListener;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedOptions;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedPopupMenu;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedPopupMenuListener;

public class PlaybackSpeedManager {
    private TextView playbackSpeedButton;
    private PlaybackSpeedPopupMenu popupMenu;

    public PlaybackSpeedManager(Context context, TextView playbackSpeedButton) {
        this.playbackSpeedButton = playbackSpeedButton;
        this.popupMenu = new PlaybackSpeedPopupMenu(context, (View)playbackSpeedButton);
    }

    public void setPlaybackSpeedButtonOnClickListener(final PlaybackSpeedPopupMenuListener playbackSpeedPopupMenuListener) {
        this.playbackSpeedButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PlaybackSpeedManager.this.popupMenu.setOnSpeedSelectedListener(new OnPlaybackSpeedSelectedListener(){

                    @Override
                    public void onSpeedSelected(float speed, String text) {
                        playbackSpeedPopupMenuListener.onSpeedSelected(speed, text);
                    }
                });
                PlaybackSpeedManager.this.popupMenu.setOnDismissListener(new PopupMenu.OnDismissListener(){

                    public void onDismiss(PopupMenu menu) {
                        playbackSpeedPopupMenuListener.onPopupMenuDismissed();
                    }
                });
                PlaybackSpeedManager.this.popupMenu.show();
                playbackSpeedPopupMenuListener.onPopupMenuShown();
            }
        });
    }

    public void setPlaybackSpeedButtonEnabled(boolean isEnabled) {
        if (this.playbackSpeedButton != null) {
            this.playbackSpeedButton.setEnabled(isEnabled);
        }
    }

    public void hidePlaybackButton(boolean showPlaybackSpeedButton) {
        if (this.playbackSpeedButton != null && !showPlaybackSpeedButton) {
            this.playbackSpeedButton.setEnabled(false);
            this.playbackSpeedButton.setVisibility(4);
        }
    }

    public void setPlaybackSpeedText(String text) {
        this.playbackSpeedButton.setText((CharSequence)text);
    }

    public void setPlaybackSpeedOptions(PlaybackSpeedOptions playbackSpeedOptions) {
        this.popupMenu.setPlaybackSpeedOptions(playbackSpeedOptions);
    }
}

