/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview.orientation;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.provider.Settings;
import android.view.OrientationEventListener;
import bg.devlabs.fullscreenvideoview.VideoView;
import bg.devlabs.fullscreenvideoview.VisibilityManager;
import bg.devlabs.fullscreenvideoview.orientation.LandscapeOrientation;
import bg.devlabs.fullscreenvideoview.orientation.PortraitOrientation;

public class OrientationManager
extends OrientationEventListener {
    private static final int LEFT_LANDSCAPE = 90;
    private static final int RIGHT_LANDSCAPE = 270;
    private static final int PORTRAIT = 0;
    private static final int ROTATE_THRESHOLD = 10;
    private VideoView videoView;
    private boolean isLandscape;
    private final ContentResolver contentResolver;
    private final VisibilityManager visibilityManager;
    private LandscapeOrientation landscapeOrientation = LandscapeOrientation.SENSOR;
    private PortraitOrientation portraitOrientation = PortraitOrientation.DEFAULT;
    private boolean shouldEnterPortrait;
    private int previousOrientation;

    public OrientationManager(Context context, VideoView interactor) {
        super(context);
        this.videoView = interactor;
        this.contentResolver = context.getContentResolver();
        this.visibilityManager = new VisibilityManager();
    }

    private void activateFullscreen() {
        this.isLandscape = true;
        this.videoView.onOrientationChanged();
        this.setOrientation(this.landscapeOrientation.getValue());
        this.visibilityManager.hideVisibleViews(this.videoView.getParentLayout());
        this.videoView.onFullscreenActivated();
        this.videoView.toggleToolbarVisibility(false);
        this.videoView.toggleSystemUiVisibility();
    }

    private void exitFullscreen() {
        this.isLandscape = false;
        this.videoView.onOrientationChanged();
        this.setOrientation(this.portraitOrientation.getValue());
        this.visibilityManager.showHiddenViews();
        this.videoView.onFullscreenDeactivated();
        this.videoView.toggleToolbarVisibility(true);
        this.videoView.toggleSystemUiVisibility();
    }

    private void setOrientation(int orientation) {
        this.videoView.changeOrientation(orientation);
    }

    public boolean shouldHandleOnBackPressed() {
        if (this.isLandscape) {
            this.setOrientation(this.portraitOrientation.getValue());
            this.videoView.onOrientationChanged();
            return true;
        }
        return false;
    }

    public void toggleFullscreen() {
        this.isLandscape = !this.isLandscape;
        int newOrientation = this.portraitOrientation.getValue();
        if (this.isLandscape) {
            newOrientation = this.landscapeOrientation.getValue();
        }
        this.setOrientation(newOrientation);
    }

    public void setLandscapeOrientation(LandscapeOrientation landscapeOrientation) {
        this.landscapeOrientation = landscapeOrientation;
    }

    public void setPortraitOrientation(PortraitOrientation portraitOrientation) {
        this.portraitOrientation = portraitOrientation;
    }

    private boolean shouldChangeOrientation(int a, int b) {
        return a > b - 10 && a < b + 10;
    }

    public void onOrientationChanged(int orientation) {
        if (!this.isRotationEnabled(this.contentResolver)) {
            return;
        }
        if ((this.shouldChangeOrientation(orientation, 90) || this.shouldChangeOrientation(orientation, 270)) && !this.shouldEnterPortrait) {
            this.shouldEnterPortrait = true;
            this.setOrientation(6);
        }
        if (this.shouldChangeOrientation(orientation, 0) && this.shouldEnterPortrait) {
            this.shouldEnterPortrait = false;
            this.setOrientation(1);
        }
    }

    private boolean isRotationEnabled(ContentResolver contentResolver) {
        return Settings.System.getInt((ContentResolver)contentResolver, (String)"accelerometer_rotation", (int)0) == 1;
    }

    public boolean isLandscape() {
        return this.isLandscape;
    }

    public void handleConfigurationChange(Configuration newConfig) {
        if (this.previousOrientation == newConfig.orientation) {
            return;
        }
        this.previousOrientation = newConfig.orientation;
        if (newConfig.orientation == 2) {
            this.activateFullscreen();
            this.videoView.focus();
        } else if (newConfig.orientation == 1) {
            this.exitFullscreen();
            this.videoView.clearFullscreenButtonTag();
        }
    }
}

