/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import bg.devlabs.fullscreenvideoview.ControllerDrawableManager;
import bg.devlabs.fullscreenvideoview.MediaController;
import bg.devlabs.fullscreenvideoview.MessageHandler;
import bg.devlabs.fullscreenvideoview.R;
import bg.devlabs.fullscreenvideoview.VideoView;
import bg.devlabs.fullscreenvideoview.listener.mediacontroller.MediaControllerListener;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedManager;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedOptions;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedPopupMenuListener;
import java.util.Locale;

class VideoControllerView
extends FrameLayout
implements MediaController,
SeekBar.OnSeekBarChangeListener {
    private static final String TAG = "VideoControllerView";
    @Nullable
    private MessageHandler handler;
    private TextView endTime;
    private TextView currentTime;
    private SeekBar progress;
    private ImageButton startPauseButton;
    private ImageButton fastForwardButton;
    private ImageButton rewindButton;
    private ImageButton fullscreenButton;
    private TextView playbackSpeedButton;
    @Nullable
    private MediaControllerListener mediaControllerListener;
    private boolean isDragging;
    private boolean seekBackwardButtonVisible = false;
    private boolean seekForwardButtonVisible = false;
    private boolean playbackSpeedButtonVisible = false;
    private PlaybackSpeedManager playbackSpeedManager;
    private ControllerDrawableManager drawableManager;
    private VideoView videoView;
    private int progressBarColor = -1;
    private int fastForwardDuration = 15000;
    private int rewindDuration = 5000;
    private ViewTreeObserver.OnWindowFocusChangeListener onWindowFocusChangeListener = new ViewTreeObserver.OnWindowFocusChangeListener(){

        public void onWindowFocusChanged(boolean hasFocus) {
            if (VideoControllerView.this.videoView.isLandscape()) {
                ((Activity)VideoControllerView.this.getContext()).getWindow().getDecorView().setSystemUiVisibility(5894);
            }
        }
    };

    public VideoControllerView(Context context) {
        super(context);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        layoutInflater.inflate(R.layout.video_controller, (ViewGroup)this, true);
        this.init();
    }

    public VideoControllerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(R.layout.video_controller, (ViewGroup)this, true);
        this.init();
        this.setupXmlAttributes(attrs);
    }

    private void init() {
        if (!this.isInEditMode()) {
            this.setVisibility(4);
        }
        this.startPauseButton = (ImageButton)this.findViewById(R.id.start_pause_media_button);
        this.fastForwardButton = (ImageButton)this.findViewById(R.id.forward_media_button);
        this.rewindButton = (ImageButton)this.findViewById(R.id.rewind_media_button);
        this.fullscreenButton = (ImageButton)this.findViewById(R.id.fullscreen_media_button);
        this.playbackSpeedButton = (TextView)this.findViewById(R.id.playback_speed_button);
        this.playbackSpeedManager = new PlaybackSpeedManager(this.getContext(), this.playbackSpeedButton);
        this.setupButtonListeners();
        this.progress = (SeekBar)this.findViewById(R.id.progress_seek_bar);
        if (this.progress != null) {
            this.setProgressBarDrawablesColors();
            this.progress.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
            this.progress.setMax(1000);
        }
        this.endTime = (TextView)this.findViewById(R.id.time);
        this.currentTime = (TextView)this.findViewById(R.id.time_current);
    }

    public void init(AttributeSet attrs) {
        this.setupXmlAttributes(attrs);
        this.updatePausePlay();
        this.updateFullScreenDrawable();
        this.updateFastForwardDrawable();
        this.updateRewindDrawable();
        this.handler = new MessageHandler(this);
        this.getViewTreeObserver().addOnWindowFocusChangeListener(this.onWindowFocusChangeListener);
    }

    @Override
    public boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public boolean isPlaying() {
        return this.videoView.isPlaying();
    }

    public void show(int timeout) {
        if (!this.isShowing()) {
            this.startPauseButton.requestFocus();
            this.setProgress();
            this.setupButtonsVisibility();
            this.setVisibility(0);
        }
        if (this.startPauseButton != null) {
            boolean isPlaying = this.videoView.isPlaying();
            Drawable playPauseDrawable = this.drawableManager.getPlayPauseDrawable(isPlaying);
            this.startPauseButton.setImageDrawable(playPauseDrawable);
        }
        this.updatePausePlay();
        this.updateFullScreenDrawable();
        if (this.handler == null) {
            return;
        }
        this.handler.show(timeout);
    }

    @Override
    public boolean isShowing() {
        return this.getVisibility() == 0;
    }

    @Override
    public void hide() {
        try {
            this.setVisibility(4);
            if (this.handler != null) {
                this.handler.hide();
            }
        }
        catch (IllegalArgumentException ignored) {
            Log.w((String)"MediaController", (String)"already removed");
        }
    }

    @Override
    public int setProgress() {
        if (this.isDragging) {
            return 0;
        }
        int position = this.videoView.getCurrentPosition();
        int duration = this.getDuration();
        if (this.progress != null) {
            if (duration > 0) {
                long pos = 1000L * (long)position / (long)duration;
                this.progress.setProgress((int)pos);
            }
            int percent = this.videoView.getBufferPercentage();
            this.progress.setSecondaryProgress(percent * 10);
        }
        if (this.endTime != null) {
            this.endTime.setText(VideoControllerView.stringForTime(duration));
        }
        if (this.currentTime != null) {
            this.currentTime.setText(VideoControllerView.stringForTime(position));
        }
        return position;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        this.performClick();
        this.show(3000);
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.setButtonsEnabled(enabled);
        if (this.progress != null) {
            this.progress.setEnabled(enabled);
        }
        this.setupButtonsVisibility();
        super.setEnabled(enabled);
    }

    private void setButtonsEnabled(boolean isEnabled) {
        if (this.startPauseButton != null) {
            this.startPauseButton.setEnabled(isEnabled);
        }
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setEnabled(isEnabled);
        }
        if (this.rewindButton != null) {
            this.rewindButton.setEnabled(isEnabled);
        }
        this.playbackSpeedManager.setPlaybackSpeedButtonEnabled(isEnabled);
    }

    public void updatePausePlay() {
        if (this.startPauseButton != null) {
            boolean isPlaying = this.videoView.isPlaying();
            Drawable playPauseDrawable = this.drawableManager.getPlayPauseDrawable(isPlaying);
            this.startPauseButton.setImageDrawable(playPauseDrawable);
        }
    }

    public void setIsDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }

    public void refreshProgress() {
        if (this.handler != null) {
            this.handler.refresh();
        }
    }

    public int getDuration() {
        return this.videoView.getDuration();
    }

    public void seekTo(int position) {
        this.videoView.seekTo(position);
    }

    public void setCurrentTime(int position) {
        if (this.currentTime != null) {
            this.currentTime.setText(VideoControllerView.stringForTime(position));
        }
    }

    public void updateSeekBarProgress(long position) {
        if (this.mediaControllerListener != null) {
            this.mediaControllerListener.onSeekBarProgressChanged(position);
        }
    }

    public void hideThumbnail() {
        this.videoView.hideThumbnail();
    }

    private void setupButtonListeners() {
        this.startPauseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VideoControllerView.this.mediaControllerListener != null) {
                    if (VideoControllerView.this.videoView.isPlaying()) {
                        VideoControllerView.this.mediaControllerListener.onPauseClicked();
                    } else {
                        VideoControllerView.this.mediaControllerListener.onPlayClicked();
                    }
                }
                VideoControllerView.this.doPauseResume();
                VideoControllerView.this.show(3000);
            }
        });
        this.fullscreenButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (VideoControllerView.this.mediaControllerListener != null) {
                    VideoControllerView.this.mediaControllerListener.onFullscreenClicked();
                }
                view.setTag((Object)"view_tag:clicked");
                VideoControllerView.this.videoView.toggleFullscreen();
                VideoControllerView.this.show(3000);
            }
        });
        this.fastForwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VideoControllerView.this.mediaControllerListener != null) {
                    VideoControllerView.this.mediaControllerListener.onFastForwardClicked();
                }
                VideoControllerView.this.videoView.seekBy(VideoControllerView.this.fastForwardDuration);
                VideoControllerView.this.setProgress();
                VideoControllerView.this.show(3000);
            }
        });
        this.rewindButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VideoControllerView.this.mediaControllerListener != null) {
                    VideoControllerView.this.mediaControllerListener.onRewindClicked();
                }
                VideoControllerView.this.videoView.seekBy(-VideoControllerView.this.rewindDuration);
                VideoControllerView.this.setProgress();
                VideoControllerView.this.show(3000);
            }
        });
        this.playbackSpeedManager.setPlaybackSpeedButtonOnClickListener(new PlaybackSpeedPopupMenuListener(){

            @Override
            public void onSpeedSelected(float speed, String text) {
                VideoControllerView.this.playbackSpeedManager.setPlaybackSpeedText(text);
                VideoControllerView.this.videoView.changePlaybackSpeed(speed);
                VideoControllerView.this.hide();
            }

            @Override
            public void onPopupMenuDismissed() {
                VideoControllerView.this.show();
            }

            @Override
            public void onPopupMenuShown() {
                VideoControllerView.this.show(0);
            }
        });
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.show(3600000);
        this.setIsDragging(true);
        this.refreshProgress();
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (!fromUser) {
            return;
        }
        long duration = this.getDuration();
        long newPosition = duration * (long)progress / 1000L;
        this.seekTo((int)newPosition);
        this.setCurrentTime((int)newPosition);
        this.updateSeekBarProgress(newPosition);
        this.hideThumbnail();
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        this.setIsDragging(false);
        this.setProgress();
        this.updatePausePlay();
        this.show(3000);
        this.refreshProgress();
    }

    private void setupXmlAttributes(AttributeSet attrs) {
        TypedArray styledAttrs = this.getContext().obtainStyledAttributes(attrs, R.styleable.VideoControllerView, 0, 0);
        this.drawableManager = new ControllerDrawableManager(this.getContext(), styledAttrs);
        this.setupDrawables();
        this.setupProgressBar(styledAttrs);
        styledAttrs.recycle();
    }

    private void setupDrawables() {
        Drawable playDrawable = this.drawableManager.getPlayDrawable();
        this.startPauseButton.setImageDrawable(playDrawable);
        Drawable enterFullscreenDrawable = this.drawableManager.getEnterFullscreenDrawable();
        this.fullscreenButton.setImageDrawable(enterFullscreenDrawable);
        Drawable rewindDrawable = this.drawableManager.getRewindDrawable();
        this.rewindButton.setImageDrawable(rewindDrawable);
        Drawable fastForwardDrawable = this.drawableManager.getFastForwardDrawable();
        this.fastForwardButton.setImageDrawable(fastForwardDrawable);
    }

    private void setupProgressBar(TypedArray a) {
        int color = a.getColor(R.styleable.VideoControllerView_progress_color, 0);
        if (color != 0) {
            this.progressBarColor = color;
        }
        this.setProgressBarDrawablesColors();
    }

    private void setProgressBarDrawablesColors() {
        this.setColorFilter(this.progress.getProgressDrawable(), this.progressBarColor);
        this.setColorFilter(this.progress.getThumb(), this.progressBarColor);
    }

    private void setColorFilter(@NonNull Drawable drawable2, int color) {
        drawable2.setColorFilter((ColorFilter)new BlendModeColorFilter(color, BlendMode.SRC_ATOP));
    }

    public void show() {
        this.show(3000);
    }

    private void setupButtonsVisibility() {
        if (this.startPauseButton != null && !this.videoView.canPause()) {
            this.startPauseButton.setEnabled(false);
            this.startPauseButton.setVisibility(4);
        }
        if (this.rewindButton != null && !this.seekBackwardButtonVisible) {
            this.rewindButton.setEnabled(false);
            this.rewindButton.setVisibility(4);
        }
        if (this.fastForwardButton != null && !this.seekForwardButtonVisible) {
            this.fastForwardButton.setEnabled(false);
            this.fastForwardButton.setVisibility(4);
        }
        this.playbackSpeedManager.hidePlaybackButton(this.playbackSpeedButtonVisible);
    }

    private static CharSequence stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        return String.format(Locale.getDefault(), "%d:%02d:%02d", hours, minutes, seconds);
    }

    private void doPauseResume() {
        this.videoView.hideThumbnail();
        this.videoView.onPauseResume();
        this.updatePausePlay();
    }

    public void onDetach() {
        if (this.handler != null) {
            this.handler.onDestroy();
            this.handler = null;
        }
        this.videoView = null;
        this.mediaControllerListener = null;
        this.getViewTreeObserver().removeOnWindowFocusChangeListener(this.onWindowFocusChangeListener);
    }

    public void setEnterFullscreenDrawable(Drawable enterFullscreenDrawable) {
        this.drawableManager.setEnterFullscreenDrawable(enterFullscreenDrawable);
    }

    public void setExitFullscreenDrawable(Drawable exitFullscreenDrawable) {
        this.drawableManager.setExitFullscreenDrawable(exitFullscreenDrawable);
    }

    public void setProgressBarColor(int progressBarColor) {
        this.progressBarColor = ContextCompat.getColor((Context)this.getContext(), (int)progressBarColor);
    }

    public void setPlayDrawable(Drawable playDrawable) {
        this.drawableManager.setPlayDrawable(playDrawable);
    }

    public void setPauseDrawable(Drawable pauseDrawable) {
        this.drawableManager.setPauseDrawable(pauseDrawable);
    }

    public void setFastForwardDuration(int fastForwardDuration) {
        this.fastForwardDuration = fastForwardDuration * 1000;
    }

    public void setRewindDuration(int rewindDuration) {
        this.rewindDuration = rewindDuration * 1000;
    }

    public void setFastForwardDrawable(Drawable fastForwardDrawable) {
        this.drawableManager.setFastForwardDrawable(fastForwardDrawable);
    }

    public void setRewindDrawable(Drawable rewindDrawable) {
        this.drawableManager.setRewindDrawable(rewindDrawable);
    }

    public void setPlaybackSpeedOptions(PlaybackSpeedOptions playbackSpeedOptions) {
        this.playbackSpeedManager.setPlaybackSpeedOptions(playbackSpeedOptions);
    }

    public void setOnMediaControllerListener(MediaControllerListener mediaControllerListener) {
        this.mediaControllerListener = mediaControllerListener;
    }

    public void setVideoView(VideoView videoView) {
        this.videoView = videoView;
    }

    public void hideProgress() {
        this.currentTime.setVisibility(8);
        this.endTime.setVisibility(8);
        this.progress.setVisibility(8);
    }

    public void hideFullscreenButton() {
        this.fullscreenButton.setVisibility(8);
    }

    void updateFullScreenDrawable() {
        if (this.fullscreenButton != null) {
            boolean isLandscape = this.videoView.isLandscape();
            Drawable fullscreenDrawable = this.drawableManager.getFullscreenDrawable(isLandscape);
            this.fullscreenButton.setImageDrawable(fullscreenDrawable);
        }
    }

    private void updateFastForwardDrawable() {
        if (this.fastForwardButton != null) {
            Drawable fastForwardDrawable = this.drawableManager.getFastForwardDrawable();
            this.fastForwardButton.setImageDrawable(fastForwardDrawable);
        }
    }

    private void updateRewindDrawable() {
        if (this.rewindButton != null) {
            Drawable rewindDrawable = this.drawableManager.getRewindDrawable();
            this.rewindButton.setImageDrawable(rewindDrawable);
        }
    }

    public boolean isSeekForwardButtonVisible() {
        return this.seekForwardButtonVisible;
    }

    public void setSeekForwardButtonVisible(boolean seekForwardButtonVisible) {
        this.seekForwardButtonVisible = seekForwardButtonVisible;
    }

    public boolean isSeekBackwardButtonVisible() {
        return this.seekBackwardButtonVisible;
    }

    public void setSeekBackwardButtonVisible(boolean seekBackwardButtonVisible) {
        this.seekBackwardButtonVisible = seekBackwardButtonVisible;
    }

    public boolean isPlaybackSpeedButtonVisible() {
        return this.playbackSpeedButtonVisible;
    }

    public void setPlaybackSpeedButtonVisible(boolean playbackSpeedButtonVisible) {
        this.playbackSpeedButtonVisible = playbackSpeedButtonVisible;
    }
}

