/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.os.Handler;
import android.os.Message;
import bg.devlabs.fullscreenvideoview.MediaController;

class MessageHandler
extends Handler {
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    private MediaController mediaController;

    MessageHandler(MediaController mediaController) {
        this.mediaController = mediaController;
    }

    public void handleMessage(Message msg) {
        if (this.mediaController == null) {
            return;
        }
        if (msg.what == 1) {
            this.mediaController.hide();
        } else {
            int position = this.mediaController.setProgress();
            if (!this.mediaController.isDragging() && this.mediaController.isShowing() && this.mediaController.isPlaying()) {
                Message message = this.obtainMessage(2);
                this.sendMessageDelayed(message, 1000 - position % 1000);
            }
        }
    }

    void show(int timeout) {
        this.refresh();
        Message msg = this.obtainMessage(1);
        if (timeout != 0) {
            this.removeMessages(1);
            this.sendMessageDelayed(msg, timeout);
        } else {
            this.removeMessages(1);
        }
    }

    void refresh() {
        this.sendEmptyMessage(2);
    }

    void hide() {
        this.removeMessages(2);
    }

    void onDestroy() {
        this.mediaController = null;
    }
}

