/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.os.Build;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import bg.devlabs.fullscreenvideoview.BitmapScaler;
import bg.devlabs.fullscreenvideoview.DeviceDimensionsManager;
import bg.devlabs.fullscreenvideoview.ErrorHandler;
import bg.devlabs.fullscreenvideoview.FullscreenVideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.R;
import bg.devlabs.fullscreenvideoview.VideoControllerView;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayerListener;
import bg.devlabs.fullscreenvideoview.VideoSurfaceView;
import bg.devlabs.fullscreenvideoview.VideoView;
import bg.devlabs.fullscreenvideoview.listener.OnErrorListener;
import bg.devlabs.fullscreenvideoview.listener.OnVideoCompletedListener;
import bg.devlabs.fullscreenvideoview.listener.mediacontroller.MediaControllerListener;
import bg.devlabs.fullscreenvideoview.model.Arguments;
import bg.devlabs.fullscreenvideoview.model.Margins;
import bg.devlabs.fullscreenvideoview.model.MediaPlayerError;
import bg.devlabs.fullscreenvideoview.orientation.LandscapeOrientation;
import bg.devlabs.fullscreenvideoview.orientation.OrientationManager;
import bg.devlabs.fullscreenvideoview.orientation.PortraitOrientation;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedOptions;
import java.io.File;
import java.util.Objects;

public class FullscreenVideoView
extends FrameLayout
implements VideoView,
VideoMediaPlayerListener {
    @Nullable
    private VideoSurfaceView surfaceView;
    @Nullable
    private SurfaceHolder surfaceHolder;
    @Nullable
    private ProgressBar progressBar;
    @Nullable
    private ImageView thumbnailImageView;
    @Nullable
    private ImageButton fullscreenButton;
    @Nullable
    private VideoControllerView controller;
    private FullscreenVideoMediaPlayer fullscreenVideoMediaPlayer;
    private boolean isMediaPlayerPrepared;
    @Nullable
    private OrientationManager orientationManager;
    private SurfaceHolder.Callback surfaceHolderCallback;
    private int seekToTimeMillis;
    private ErrorHandler errorHandler = new ErrorHandler();
    @Nullable
    private AttributeSet attrs = null;
    private Arguments args = new Arguments();
    @Nullable
    private OnVideoCompletedListener onVideoCompletedListener;
    private boolean isVisible;
    private int originalWidth;
    private int originalHeight;
    private Margins margins;

    public FullscreenVideoView(@NonNull Context context) {
        super(context);
        this.init(null);
    }

    public FullscreenVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.attrs = attrs;
        this.init(attrs);
    }

    public FullscreenVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.attrs = attrs;
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.findChildViews();
        if (!this.isInEditMode()) {
            this.fullscreenVideoMediaPlayer = new FullscreenVideoMediaPlayer(this);
            this.orientationManager = new OrientationManager(this.getContext(), this);
            this.orientationManager.enable();
        }
        this.setUpSurfaceHolder();
        if (this.controller != null) {
            this.controller.setVideoView(this);
            this.controller.init(attrs);
        }
        this.setupProgressBarColor();
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.initOnBackPressedListener();
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                view.performClick();
                if (FullscreenVideoView.this.controller != null) {
                    FullscreenVideoView.this.controller.show();
                }
                return false;
            }
        });
    }

    @Override
    public boolean isPlaying() {
        return this.fullscreenVideoMediaPlayer.isPlaying();
    }

    @Override
    public void seekBy(int duration) {
        int pos = this.fullscreenVideoMediaPlayer.getCurrentPosition();
        this.fullscreenVideoMediaPlayer.seekTo(pos += duration);
    }

    @Override
    public void changePlaybackSpeed(float speed) {
        if (this.fullscreenVideoMediaPlayer != null) {
            this.fullscreenVideoMediaPlayer.changePlaybackSpeed(speed);
        }
    }

    @Override
    public boolean canPause() {
        return this.fullscreenVideoMediaPlayer.canPause();
    }

    @Override
    public int getCurrentPosition() {
        return this.fullscreenVideoMediaPlayer.getCurrentPosition();
    }

    @Override
    public int getDuration() {
        return this.fullscreenVideoMediaPlayer.getDuration();
    }

    @Override
    public int getBufferPercentage() {
        return this.fullscreenVideoMediaPlayer.getBufferPercentage();
    }

    @Override
    public void onPauseResume() {
        this.fullscreenVideoMediaPlayer.onPauseResume();
    }

    @Override
    public void seekTo(int position) {
        this.fullscreenVideoMediaPlayer.seekTo(position);
    }

    @Override
    public boolean isLandscape() {
        return this.orientationManager != null && this.orientationManager.isLandscape();
    }

    @Override
    public void toggleFullscreen() {
        if (this.orientationManager != null) {
            this.orientationManager.toggleFullscreen();
        }
    }

    @Override
    public void hideThumbnail() {
        if (this.thumbnailImageView != null && this.thumbnailImageView.getVisibility() == 0) {
            this.thumbnailImageView.setVisibility(8);
        }
    }

    @Override
    public void onMediaPlayerPrepared(MediaPlayer mediaPlayer, int videoWidth, int videoHeight, boolean isAutoStartEnabled) {
        this.hideProgressBar();
        if (this.surfaceView != null) {
            this.surfaceView.updateLayoutParams(videoWidth, videoHeight);
        }
        if (!this.isVisible) {
            this.isMediaPlayerPrepared = true;
            if (isAutoStartEnabled) {
                mediaPlayer.start();
                this.hideThumbnail();
            }
        }
        this.seekTo(this.seekToTimeMillis);
    }

    @Override
    public void onMediaPlayerError(MediaPlayerError error) {
        this.errorHandler.handle(this.getContext(), error);
    }

    @Override
    public void onMediaPlayerCompletion() {
        if (this.onVideoCompletedListener != null) {
            this.onVideoCompletedListener.onFinished();
        }
    }

    @Override
    public ViewGroup getParentLayout() {
        Window window = ((Activity)this.getContext()).getWindow();
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        return (ViewGroup)decorView.findViewById(0x1020002);
    }

    private void setUpSurfaceHolder() {
        if (this.surfaceView != null) {
            this.surfaceHolderCallback = new SurfaceHolder.Callback(){

                public void surfaceCreated(SurfaceHolder holder) {
                    if (FullscreenVideoView.this.fullscreenVideoMediaPlayer != null) {
                        FullscreenVideoView.this.fullscreenVideoMediaPlayer.setDisplay(FullscreenVideoView.this.surfaceHolder);
                    }
                }

                public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                }

                public void surfaceDestroyed(SurfaceHolder holder) {
                    if (FullscreenVideoView.this.fullscreenVideoMediaPlayer != null && FullscreenVideoView.this.isMediaPlayerPrepared) {
                        FullscreenVideoView.this.fullscreenVideoMediaPlayer.pause();
                    }
                }
            };
            this.surfaceHolder = this.surfaceView.getHolder();
            this.surfaceHolder.addCallback(this.surfaceHolderCallback);
        }
    }

    private void findChildViews() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(R.layout.fullscreen_video_view, (ViewGroup)this, true);
        this.surfaceView = (VideoSurfaceView)this.findViewById(R.id.surface_view);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.controller = (VideoControllerView)this.findViewById(R.id.video_controller);
        this.thumbnailImageView = (ImageView)this.findViewById(R.id.thumbnail_image_view);
    }

    private void initOnBackPressedListener() {
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                return event.getAction() == 1 && keyCode == 4 && FullscreenVideoView.this.orientationManager != null && FullscreenVideoView.this.orientationManager.shouldHandleOnBackPressed();
            }
        });
    }

    public FullscreenVideoView videoFile(File videoFile) {
        this.setupMediaPlayer(videoFile.getPath());
        return this;
    }

    public FullscreenVideoView videoUrl(String videoUrl) {
        this.setupMediaPlayer(videoUrl);
        return this;
    }

    public FullscreenVideoView enableAutoStart() {
        if (this.fullscreenVideoMediaPlayer != null) {
            this.fullscreenVideoMediaPlayer.enableAutoStart();
            this.args.autoStartEnabled = true;
        }
        return this;
    }

    public FullscreenVideoView enterFullscreenDrawable(@NonNull Drawable drawable2) {
        if (this.controller != null) {
            this.controller.setEnterFullscreenDrawable(drawable2);
        }
        this.args.enterFullscreenDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView enterFullscreenDrawable(@DrawableRes int drawableResId) {
        return this.enterFullscreenDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView exitFullscreenDrawable(@NonNull Drawable drawable2) {
        if (this.controller != null) {
            this.controller.setExitFullscreenDrawable(drawable2);
        }
        this.args.exitFullscreenDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView exitFullscreenDrawable(@DrawableRes int drawableResId) {
        return this.exitFullscreenDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView playDrawable(@NonNull Drawable drawable2) {
        if (this.controller != null) {
            this.controller.setPlayDrawable(drawable2);
        }
        this.args.playDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView playDrawable(@DrawableRes int drawableResId) {
        return this.playDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView pauseDrawable(@NonNull Drawable drawable2) {
        if (this.controller != null) {
            this.controller.setPauseDrawable(drawable2);
        }
        this.args.pauseDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView pauseDrawable(@DrawableRes int drawableResId) {
        return this.pauseDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView fastForwardDrawable(@NonNull Drawable drawable2) {
        if (this.controller != null) {
            this.controller.setFastForwardDrawable(drawable2);
        }
        this.args.fastForwardDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView fastForwardDrawable(@DrawableRes int drawableResId) {
        return this.fastForwardDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView rewindDrawable(@NonNull Drawable drawable2) {
        if (this.controller != null) {
            this.controller.setRewindDrawable(drawable2);
        }
        this.args.rewindDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView rewindDrawable(@DrawableRes int drawableResId) {
        return this.rewindDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView progressBarColor(int progressBarColor) {
        if (this.controller != null) {
            this.controller.setProgressBarColor(progressBarColor);
        }
        this.args.progressBarColor = progressBarColor;
        return this;
    }

    public FullscreenVideoView fastForwardSeconds(int fastForwardSeconds) {
        if (this.controller != null) {
            this.controller.setFastForwardDuration(fastForwardSeconds);
        }
        this.args.fastForwardSeconds = fastForwardSeconds;
        return this;
    }

    public FullscreenVideoView rewindSeconds(int rewindSeconds) {
        if (this.controller != null) {
            this.controller.setRewindDuration(rewindSeconds);
        }
        this.args.rewindSeconds = rewindSeconds;
        return this;
    }

    public FullscreenVideoView landscapeOrientation(LandscapeOrientation landscapeOrientation) {
        if (this.orientationManager != null) {
            this.orientationManager.setLandscapeOrientation(landscapeOrientation);
        }
        this.args.landscapeOrientation = landscapeOrientation;
        return this;
    }

    public FullscreenVideoView portraitOrientation(PortraitOrientation portraitOrientation) {
        if (this.orientationManager != null) {
            this.orientationManager.setPortraitOrientation(portraitOrientation);
        }
        this.args.portraitOrientation = portraitOrientation;
        return this;
    }

    public FullscreenVideoView disablePause() {
        if (this.fullscreenVideoMediaPlayer != null) {
            this.fullscreenVideoMediaPlayer.disablePause();
        }
        this.args.disablePause = true;
        return this;
    }

    public FullscreenVideoView addSeekForwardButton() {
        if (this.controller != null) {
            this.controller.setSeekForwardButtonVisible(true);
        }
        this.args.addSeekForwardButton = true;
        return this;
    }

    public FullscreenVideoView addSeekBackwardButton() {
        if (this.controller != null) {
            this.controller.setSeekBackwardButtonVisible(true);
        }
        this.args.addSeekBackwardButton = true;
        return this;
    }

    @RequiresApi(value=23)
    public FullscreenVideoView addPlaybackSpeedButton() {
        if (this.controller != null) {
            this.controller.setPlaybackSpeedButtonVisible(true);
        }
        this.args.addPlaybackSpeedButton = true;
        return this;
    }

    public FullscreenVideoView playbackSpeedOptions(PlaybackSpeedOptions playbackSpeedOptions) {
        if (this.controller != null) {
            this.controller.setPlaybackSpeedOptions(playbackSpeedOptions);
        }
        this.args.playbackSpeedOptions = playbackSpeedOptions;
        return this;
    }

    public FullscreenVideoView thumbnail(int thumbnailResId) {
        if (this.thumbnailImageView != null) {
            Bitmap thumbnail = BitmapScaler.scaleImage(this.getResources(), thumbnailResId);
            this.thumbnailImageView.setImageBitmap(thumbnail);
            this.args.thumbnailResId = thumbnailResId;
        }
        return this;
    }

    public FullscreenVideoView hideProgress() {
        if (this.controller != null) {
            this.controller.hideProgress();
        }
        this.args.hideProgress = true;
        return this;
    }

    public FullscreenVideoView hideFullscreenButton() {
        if (this.controller != null) {
            this.controller.hideFullscreenButton();
        }
        this.args.hideFullscreenButton = true;
        return this;
    }

    public FullscreenVideoView addOnErrorListener(OnErrorListener onErrorListener) {
        this.errorHandler.setOnErrorListener(onErrorListener);
        return this;
    }

    public FullscreenVideoView addOnVideoCompletedListener(OnVideoCompletedListener listener) {
        this.onVideoCompletedListener = listener;
        return this;
    }

    public FullscreenVideoView mediaControllerListener(MediaControllerListener mediaControllerListener) {
        if (this.controller != null) {
            this.controller.setOnMediaControllerListener(mediaControllerListener);
        }
        return this;
    }

    public FullscreenVideoView setSeekToTimeMillis(int timeMillis) {
        this.seekToTimeMillis = timeMillis;
        this.args.seekToTimeMillis = timeMillis;
        return this;
    }

    public void pause() {
        if (this.fullscreenVideoMediaPlayer != null) {
            this.fullscreenVideoMediaPlayer.pause();
        }
    }

    public void play() {
        if (this.fullscreenVideoMediaPlayer != null) {
            this.fullscreenVideoMediaPlayer.start();
            this.hideThumbnail();
        }
    }

    public void changeUrl(@NonNull String url) {
        this.changeSource(url);
    }

    public void changeVideoFile(@NonNull File videoFile) {
        this.changeSource(videoFile.getPath());
    }

    private Drawable getDrawable(int drawableResId) {
        return ContextCompat.getDrawable((Context)this.getContext(), (int)drawableResId);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.fullscreenButton = (ImageButton)this.findViewById(R.id.fullscreen_media_button);
        String fullscreenButtonTag = (String)this.fullscreenButton.getTag();
        if (!Objects.equals(fullscreenButtonTag, "view_tag:clicked")) {
            return;
        }
        if (this.orientationManager == null) {
            return;
        }
        this.orientationManager.handleConfigurationChange(newConfig);
    }

    protected void onDetachedFromWindow() {
        this.handleOnDetach();
        super.onDetachedFromWindow();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.isVisible = visibility != 0;
    }

    private void handleOnDetach() {
        if (this.controller != null) {
            this.controller.onDetach();
            this.controller = null;
        }
        if (this.orientationManager != null) {
            this.orientationManager.disable();
            this.orientationManager = null;
        }
        if (this.fullscreenVideoMediaPlayer != null) {
            this.fullscreenVideoMediaPlayer.onDetach();
            this.fullscreenVideoMediaPlayer = null;
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback(this.surfaceHolderCallback);
            this.surfaceHolder.getSurface().release();
            this.surfaceHolder = null;
        }
        if (this.surfaceView != null) {
            this.surfaceView.invalidate();
            this.surfaceView.destroyDrawingCache();
            this.surfaceView = null;
        }
        this.progressBar = null;
        this.surfaceHolderCallback = null;
        this.attrs = null;
        this.setOnKeyListener(null);
        this.setOnTouchListener(null);
        this.errorHandler.onDestroy();
        this.detachAllViewsFromParent();
    }

    public void setupMediaPlayer(String videoPath) {
        this.showProgress();
        if (this.fullscreenVideoMediaPlayer != null) {
            this.fullscreenVideoMediaPlayer.init(videoPath);
            this.fullscreenVideoMediaPlayer.prepareAsync();
        }
    }

    private void setupProgressBarColor() {
        int shortAnimTime = this.getResources().getInteger(0x10E0000);
        if (this.progressBar != null) {
            this.progressBar.animate().setDuration((long)shortAnimTime);
        }
    }

    private void hideProgressBar() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(4);
        }
    }

    private void showProgress() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
    }

    @Override
    public void onOrientationChanged() {
        if (this.controller != null) {
            this.controller.updateFullScreenDrawable();
        }
        if (this.surfaceView != null && this.fullscreenVideoMediaPlayer != null) {
            this.surfaceView.updateLayoutParams(this.fullscreenVideoMediaPlayer.getVideoWidth(), this.fullscreenVideoMediaPlayer.getVideoHeight());
        }
    }

    @Override
    public void onFullscreenActivated() {
        this.originalWidth = this.getWidth();
        this.originalHeight = this.getHeight();
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        this.margins = new Margins(marginLayoutParams.leftMargin, marginLayoutParams.topMargin, marginLayoutParams.rightMargin, marginLayoutParams.bottomMargin);
        this.updateLayoutParams(marginLayoutParams);
    }

    @Override
    public void onFullscreenDeactivated() {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        params.width = this.originalWidth;
        params.height = this.originalHeight;
        params.setMargins(this.margins.getLeft(), this.margins.getTop(), this.margins.getRight(), this.margins.getBottom());
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public void toggleSystemUiVisibility() {
        Window activityWindow = ((Activity)this.getContext()).getWindow();
        View decorView = activityWindow.getDecorView();
        int newUiOptions = decorView.getSystemUiVisibility();
        newUiOptions ^= 2;
        newUiOptions ^= 4;
        decorView.setSystemUiVisibility(newUiOptions ^= 0x1000);
    }

    @Override
    public void toggleToolbarVisibility(boolean isVisible) {
        if (this.getContext() instanceof AppCompatActivity) {
            this.toggleSupportActionBarVisibility(isVisible);
        }
        if (this.getContext() instanceof Activity) {
            this.toggleActionBarVisibility(isVisible);
        }
    }

    @Override
    public void changeOrientation(int orientation) {
        ((Activity)this.getContext()).setRequestedOrientation(orientation);
    }

    @Override
    public void focus() {
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
    }

    @Override
    public void clearFullscreenButtonTag() {
        if (this.fullscreenButton != null) {
            this.fullscreenButton.setTag(null);
        }
    }

    private void toggleActionBarVisibility(boolean isVisible) {
        android.app.ActionBar actionBar = ((Activity)this.getContext()).getActionBar();
        if (actionBar != null) {
            if (isVisible) {
                actionBar.show();
            } else {
                actionBar.hide();
            }
        }
    }

    private void toggleSupportActionBarVisibility(boolean isVisible) {
        ActionBar supportActionBar = ((AppCompatActivity)this.getContext()).getSupportActionBar();
        if (supportActionBar != null) {
            if (isVisible) {
                supportActionBar.show();
            } else {
                supportActionBar.hide();
            }
        }
    }

    private void updateLayoutParams(ViewGroup.MarginLayoutParams params) {
        Context context = this.getContext();
        DeviceDimensionsManager deviceDimensionsManager = DeviceDimensionsManager.getInstance();
        params.width = deviceDimensionsManager.getRealWidth(context);
        params.height = deviceDimensionsManager.getRealHeight(context);
        params.setMargins(0, 0, 0, 0);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void changeSource(String videoPath) {
        PlaybackSpeedOptions playbackSpeedOptions;
        PortraitOrientation portraitOrientation;
        LandscapeOrientation landscapeOrientation;
        int rewindSeconds;
        int fastForwardSeconds;
        int progressBarColor;
        Drawable rewindDrawable;
        Drawable fastForwardDrawable;
        Drawable pauseDrawable;
        Drawable playDrawable;
        Drawable exitFullscreenDrawable;
        Drawable enterFullscreenDrawable;
        this.handleOnDetach();
        this.init(this.attrs);
        this.setupMediaPlayer(videoPath);
        if (this.args.autoStartEnabled) {
            this.enableAutoStart();
        }
        if ((enterFullscreenDrawable = this.args.enterFullscreenDrawable) != null) {
            this.enterFullscreenDrawable(enterFullscreenDrawable);
        }
        if ((exitFullscreenDrawable = this.args.exitFullscreenDrawable) != null) {
            this.exitFullscreenDrawable(exitFullscreenDrawable);
        }
        if ((playDrawable = this.args.playDrawable) != null) {
            this.playDrawable(playDrawable);
        }
        if ((pauseDrawable = this.args.pauseDrawable) != null) {
            this.pauseDrawable(pauseDrawable);
        }
        if ((fastForwardDrawable = this.args.fastForwardDrawable) != null) {
            this.fastForwardDrawable(fastForwardDrawable);
        }
        if ((rewindDrawable = this.args.rewindDrawable) != null) {
            this.rewindDrawable(rewindDrawable);
        }
        if ((progressBarColor = this.args.progressBarColor) != -1) {
            this.progressBarColor(progressBarColor);
        }
        if ((fastForwardSeconds = this.args.fastForwardSeconds) != -1) {
            this.fastForwardSeconds(fastForwardSeconds);
        }
        if ((rewindSeconds = this.args.rewindSeconds) != -1) {
            this.rewindSeconds(rewindSeconds);
        }
        if ((landscapeOrientation = this.args.landscapeOrientation) != null) {
            this.landscapeOrientation(landscapeOrientation);
        }
        if ((portraitOrientation = this.args.portraitOrientation) != null) {
            this.portraitOrientation(portraitOrientation);
        }
        if (this.args.disablePause) {
            this.disablePause();
        }
        if (this.args.addSeekForwardButton) {
            this.addSeekForwardButton();
        }
        if (this.args.addSeekBackwardButton) {
            this.addSeekBackwardButton();
        }
        if (this.args.addPlaybackSpeedButton && Build.VERSION.SDK_INT >= 23) {
            this.addPlaybackSpeedButton();
        }
        if ((playbackSpeedOptions = this.args.playbackSpeedOptions) != null) {
            this.playbackSpeedOptions(playbackSpeedOptions);
        }
        if (this.args.hideProgress) {
            this.hideProgress();
        }
        if (this.args.hideFullscreenButton) {
            this.hideFullscreenButton();
        }
        int timeMillis = this.args.seekToTimeMillis;
        if (this.args.seekToTimeMillis != -1) {
            this.setSeekToTimeMillis(timeMillis);
        }
    }
}

