/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.os.Build;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayerListener;
import bg.devlabs.fullscreenvideoview.model.MediaPlayerError;
import bg.devlabs.fullscreenvideoview.model.MediaPlayerErrorType;
import java.io.IOException;

class FullscreenVideoMediaPlayer
extends MediaPlayer {
    private VideoMediaPlayerListener listener;
    private boolean isAutoStartEnabled;
    private boolean canPause = true;

    FullscreenVideoMediaPlayer(VideoMediaPlayerListener listener) {
        this.listener = listener;
    }

    void init(String videoPath) {
        try {
            this.setDataSource(videoPath);
            this.setupAudio();
            this.setupOnPreparedListener();
            this.setupOnErrorListener();
            this.setupOnCompletionListener();
        }
        catch (IOException exception) {
            this.listener.onMediaPlayerError(new MediaPlayerError(MediaPlayerErrorType.DATA_SOURCE_READ, exception.getLocalizedMessage()));
        }
    }

    private void setupAudio() {
        if (Build.VERSION.SDK_INT >= 21) {
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(2).setLegacyStreamType(3).build();
            this.setAudioAttributes(audioAttributes);
        } else {
            this.setAudioStreamType(3);
        }
    }

    private void setupOnPreparedListener() {
        this.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                FullscreenVideoMediaPlayer.this.listener.onMediaPlayerPrepared(mediaPlayer, FullscreenVideoMediaPlayer.this.getVideoWidth(), FullscreenVideoMediaPlayer.this.getVideoHeight(), mediaPlayer != null && FullscreenVideoMediaPlayer.this.isAutoStartEnabled);
            }
        });
    }

    private void setupOnErrorListener() {
        this.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                FullscreenVideoMediaPlayer.this.listener.onMediaPlayerError(new MediaPlayerError(MediaPlayerErrorType.ASYNC_OPERATION, what));
                return false;
            }
        });
    }

    private void setupOnCompletionListener() {
        this.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                FullscreenVideoMediaPlayer.this.listener.onMediaPlayerCompletion();
            }
        });
    }

    public int getBufferPercentage() {
        return 0;
    }

    public boolean canPause() {
        return this.canPause;
    }

    public void onPauseResume() {
        if (this.isPlaying()) {
            this.pause();
        } else {
            this.start();
        }
    }

    public void onDetach() {
        this.setOnPreparedListener(null);
        if (this.isPlaying()) {
            this.stop();
        }
        this.release();
    }

    public void enableAutoStart() {
        this.isAutoStartEnabled = true;
    }

    public void disablePause() {
        this.canPause = false;
    }

    @TargetApi(value=23)
    public void changePlaybackSpeed(float speed) {
        PlaybackParams playbackParams = new PlaybackParams();
        playbackParams.setSpeed(speed);
        this.setPlaybackParams(playbackParams);
    }
}

