/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import androidx.annotation.Nullable;
import bg.devlabs.fullscreenvideoview.R;
import bg.devlabs.fullscreenvideoview.listener.FullscreenVideoViewException;
import bg.devlabs.fullscreenvideoview.listener.OnErrorListener;
import bg.devlabs.fullscreenvideoview.model.MediaPlayerError;

class ErrorHandler {
    @Nullable
    private OnErrorListener onErrorListener;

    ErrorHandler() {
    }

    void setOnErrorListener(@Nullable OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    void onDestroy() {
        this.onErrorListener = null;
    }

    void handle(Context context, MediaPlayerError error) {
        switch (error.getType()) {
            case DATA_SOURCE_READ: {
                this.onError(error.getMessage());
            }
            case ASYNC_OPERATION: {
                this.handleAsyncOperationError(context, error.getCode());
            }
        }
    }

    private void onError(String message) {
        if (this.onErrorListener != null) {
            FullscreenVideoViewException exception = new FullscreenVideoViewException(message);
            this.onErrorListener.onError(exception);
        }
    }

    private void handleAsyncOperationError(Context context, int errorCode) {
        switch (errorCode) {
            case -1004: {
                this.onError(-1004, context.getString(R.string.media_error_io));
                break;
            }
            case -1007: {
                this.onError(-1007, context.getString(R.string.media_error_malformed));
                break;
            }
            case 200: {
                this.onError(200, context.getString(R.string.media_error_not_valid_for_progressive_playback));
                break;
            }
            case 100: {
                this.onError(100, context.getString(R.string.media_error_server_died));
                break;
            }
            case -110: {
                this.onError(-110, context.getString(R.string.media_error_timed_out));
                break;
            }
            case 1: {
                this.onError(1, context.getString(R.string.media_error_unknown));
                break;
            }
            case -1010: {
                this.onError(-1010, context.getString(R.string.media_error_unsupported));
                break;
            }
            default: {
                this.onError(1000, context.getString(R.string.media_error_general));
            }
        }
    }

    private void onError(int code, String message) {
        if (this.onErrorListener != null) {
            FullscreenVideoViewException exception = new FullscreenVideoViewException(code, message);
            this.onErrorListener.onError(exception);
        }
    }
}

