/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import androidx.core.content.ContextCompat;
import bg.devlabs.fullscreenvideoview.R;

public class ControllerDrawableManager {
    private Drawable exitFullscreenDrawable;
    private Drawable enterFullscreenDrawable;
    private Drawable playDrawable;
    private Drawable pauseDrawable;
    private Drawable fastForwardDrawable;
    private Drawable rewindDrawable;

    ControllerDrawableManager(Context context, TypedArray styledAttrs) {
        Drawable exitFullscreenDrawableXml = styledAttrs.getDrawable(R.styleable.VideoControllerView_exit_fullscreen_drawable);
        this.exitFullscreenDrawable = exitFullscreenDrawableXml != null ? exitFullscreenDrawableXml : this.getDrawable(context, R.drawable.ic_fullscreen_exit_white_48dp);
        Drawable enterFullscreenDrawableXml = styledAttrs.getDrawable(R.styleable.VideoControllerView_enter_fullscreen_drawable);
        this.enterFullscreenDrawable = enterFullscreenDrawableXml != null ? enterFullscreenDrawableXml : this.getDrawable(context, R.drawable.ic_fullscreen_white_48dp);
        Drawable playDrawableXml = styledAttrs.getDrawable(R.styleable.VideoControllerView_play_drawable);
        this.playDrawable = playDrawableXml != null ? playDrawableXml : this.getDrawable(context, R.drawable.ic_play_arrow_white_48dp);
        Drawable pauseDrawableXml = styledAttrs.getDrawable(R.styleable.VideoControllerView_pause_drawable);
        this.pauseDrawable = pauseDrawableXml != null ? pauseDrawableXml : this.getDrawable(context, R.drawable.ic_pause_white_48dp);
        Drawable fastForwardDrawableXml = styledAttrs.getDrawable(R.styleable.VideoControllerView_ffwd_drawable);
        this.fastForwardDrawable = fastForwardDrawableXml != null ? fastForwardDrawableXml : this.getDrawable(context, R.drawable.ic_fast_forward_white_48dp);
        Drawable rewindDrawableXml = styledAttrs.getDrawable(R.styleable.VideoControllerView_rew_drawable);
        this.rewindDrawable = rewindDrawableXml != null ? rewindDrawableXml : this.getDrawable(context, R.drawable.ic_fast_rewind_white_48dp);
    }

    Drawable getPlayDrawable() {
        return this.playDrawable;
    }

    void setPlayDrawable(Drawable playDrawable) {
        if (playDrawable != null) {
            this.playDrawable = playDrawable;
        }
    }

    void setPauseDrawable(Drawable pauseDrawable) {
        if (pauseDrawable != null) {
            this.pauseDrawable = pauseDrawable;
        }
    }

    Drawable getEnterFullscreenDrawable() {
        return this.enterFullscreenDrawable;
    }

    void setEnterFullscreenDrawable(Drawable enterFullscreenDrawable) {
        if (enterFullscreenDrawable != null) {
            this.enterFullscreenDrawable = enterFullscreenDrawable;
        }
    }

    void setExitFullscreenDrawable(Drawable exitFullscreenDrawable) {
        if (exitFullscreenDrawable != null) {
            this.exitFullscreenDrawable = exitFullscreenDrawable;
        }
    }

    Drawable getRewindDrawable() {
        return this.rewindDrawable;
    }

    void setRewindDrawable(Drawable rewindDrawable) {
        if (rewindDrawable != null) {
            this.rewindDrawable = rewindDrawable;
        }
    }

    Drawable getFastForwardDrawable() {
        return this.fastForwardDrawable;
    }

    void setFastForwardDrawable(Drawable fastForwardDrawable) {
        if (fastForwardDrawable != null) {
            this.fastForwardDrawable = fastForwardDrawable;
        }
    }

    Drawable getPlayPauseDrawable(boolean isPlaying) {
        return isPlaying ? this.pauseDrawable : this.playDrawable;
    }

    Drawable getFullscreenDrawable(boolean isLandscape) {
        return isLandscape ? this.exitFullscreenDrawable : this.enterFullscreenDrawable;
    }

    private Drawable getDrawable(Context context, int drawableResId) {
        return ContextCompat.getDrawable((Context)context, (int)drawableResId);
    }
}

