/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

class BitmapScaler {
    BitmapScaler() {
    }

    static Bitmap scaleImage(Resources resources, int thumbnailResId) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)thumbnailResId, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapScaler.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resources, (int)thumbnailResId, (BitmapFactory.Options)options);
    }

    private static int calculateInSampleSize(BitmapFactory.Options options) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        int requiredHeight = 500;
        int requiredWidth = 500;
        if (height > requiredHeight || width > requiredWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= requiredHeight && halfWidth / inSampleSize >= requiredWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

