/*
 * Copyright 2017 Dev Labs
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package bg.devlabs.fullscreenvideoview.orientation;

import static android.content.pm.ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE;
import static android.content.pm.ActivityInfo.SCREEN_ORIENTATION_REVERSE_LANDSCAPE;
import static android.content.pm.ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE;
import static android.content.pm.ActivityInfo.SCREEN_ORIENTATION_USER_LANDSCAPE;

/**
 * Portrait orientation model class to abstract the integer system portrait orientation
 * values from ActivityInfo class.
 */
@SuppressWarnings("unused")
public enum LandscapeOrientation {
    SENSOR(SCREEN_ORIENTATION_SENSOR_LANDSCAPE),
    DEFAULT(SCREEN_ORIENTATION_LANDSCAPE),
    REVERSE(SCREEN_ORIENTATION_REVERSE_LANDSCAPE),
    USER(SCREEN_ORIENTATION_USER_LANDSCAPE);

    private final int value;

    LandscapeOrientation(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }
}
