/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview.playbackspeed;

import android.content.Context;
import android.support.v7.widget.PopupMenu;
import android.view.MenuItem;
import android.view.View;
import bg.devlabs.fullscreenvideoview.playbackspeed.OnPlaybackSpeedSelectedListener;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class PlaybackSpeedPopupMenu
extends PopupMenu {
    private ArrayList<Float> values = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.25f), Float.valueOf(0.5f), Float.valueOf(0.75f), Float.valueOf(1.0f), Float.valueOf(1.25f), Float.valueOf(1.5f), Float.valueOf(2.0f)));

    public PlaybackSpeedPopupMenu(Context context, View anchor) {
        super(context, anchor);
        this.addMenuButtons();
    }

    public void setOnSpeedSelectedListener(final OnPlaybackSpeedSelectedListener listener) {
        this.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                float speed = ((Float)PlaybackSpeedPopupMenu.this.values.get(item.getItemId())).floatValue();
                String text = String.format(Locale.getDefault(), "%.2f", Float.valueOf(speed)) + "x";
                listener.onSpeedSelected(speed, text);
                return true;
            }
        });
    }

    public void setPlaybackSpeedOptions(PlaybackSpeedOptions playbackSpeedOptions) {
        this.values.clear();
        this.values = playbackSpeedOptions.getSpeeds();
        this.removeMenuButtons();
        this.addMenuButtons();
    }

    private void removeMenuButtons() {
        this.getMenu().removeGroup(0);
    }

    private void addMenuButtons() {
        int size = this.values.size();
        int id2 = -1;
        for (int i = 0; i < size; ++i) {
            String title = String.format(Locale.getDefault(), "%.2f", this.values.get(i)) + "x";
            this.getMenu().add(0, ++id2, 0, (CharSequence)title);
        }
    }
}

