/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.SeekBar;
import android.widget.TextView;
import bg.devlabs.fullscreenvideoview.ButtonManager;
import bg.devlabs.fullscreenvideoview.R;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.listener.mediacontroller.MediaControllerListener;
import bg.devlabs.fullscreenvideoview.orientation.OrientationManager;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedOptions;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedPopupMenuListener;
import java.lang.ref.WeakReference;
import java.util.Locale;

class VideoControllerView
extends FrameLayout {
    private static final String TAG = "VideoControllerView";
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    @Nullable
    private VideoMediaPlayer videoMediaPlayer;
    private TextView endTime;
    private TextView currentTime;
    private boolean isDragging;
    @Nullable
    private Handler handler;
    private SeekBar progress;
    @Nullable
    private SeekBar.OnSeekBarChangeListener seekListener = new OnSeekChangeListener();
    @Nullable
    private MediaControllerListener mediaControllerListener;
    private ButtonManager buttonManager;
    private int progressBarColor = -1;
    private int fastForwardDuration = 15000;
    private int rewindDuration = 5000;

    public VideoControllerView(Context context) {
        super(context);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        layoutInflater.inflate(R.layout.video_controller, (ViewGroup)this, true);
        this.init();
    }

    public VideoControllerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(R.layout.video_controller, (ViewGroup)this, true);
        this.init();
        this.setupXmlAttributes(attrs);
    }

    private void init() {
        if (!this.isInEditMode()) {
            this.setVisibility(4);
        }
        this.buttonManager = new ButtonManager(this.getContext(), (ImageButton)this.findViewById(R.id.start_pause_media_button), (ImageButton)this.findViewById(R.id.forward_media_button), (ImageButton)this.findViewById(R.id.rewind_media_button), (ImageButton)this.findViewById(R.id.fullscreen_media_button), (TextView)this.findViewById(R.id.playback_speed_button));
        this.setupButtonListeners();
        this.progress = (SeekBar)this.findViewById(R.id.progress_seek_bar);
        if (this.progress != null) {
            this.progress.getProgressDrawable().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
            this.progress.getThumb().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
            this.progress.setOnSeekBarChangeListener(this.seekListener);
            this.progress.setMax(1000);
        }
        this.endTime = (TextView)this.findViewById(R.id.time);
        this.currentTime = (TextView)this.findViewById(R.id.time_current);
    }

    private void setupButtonListeners() {
        this.buttonManager.setStartPauseButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VideoControllerView.this.videoMediaPlayer != null && VideoControllerView.this.mediaControllerListener != null) {
                    if (VideoControllerView.this.videoMediaPlayer.isPlaying()) {
                        VideoControllerView.this.mediaControllerListener.onPauseClicked();
                    } else {
                        VideoControllerView.this.mediaControllerListener.onPlayClicked();
                    }
                }
                VideoControllerView.this.doPauseResume();
                VideoControllerView.this.show(3000);
            }
        });
        this.buttonManager.setFullscreenButtonClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (VideoControllerView.this.mediaControllerListener != null) {
                    VideoControllerView.this.mediaControllerListener.onFullscreenClicked();
                }
                view.setTag((Object)"view_tag:clicked");
                VideoControllerView.this.doToggleFullscreen();
                VideoControllerView.this.show(3000);
            }
        });
        this.buttonManager.setFfwdButtonOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VideoControllerView.this.videoMediaPlayer == null) {
                    return;
                }
                if (VideoControllerView.this.mediaControllerListener != null) {
                    VideoControllerView.this.mediaControllerListener.onFastForwardClicked();
                }
                int pos = VideoControllerView.this.videoMediaPlayer.getCurrentPosition();
                VideoControllerView.this.videoMediaPlayer.seekTo(pos += VideoControllerView.this.fastForwardDuration);
                VideoControllerView.this.setProgress();
                VideoControllerView.this.show(3000);
            }
        });
        this.buttonManager.setRewButtonOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VideoControllerView.this.videoMediaPlayer == null) {
                    return;
                }
                if (VideoControllerView.this.mediaControllerListener != null) {
                    VideoControllerView.this.mediaControllerListener.onRewindClicked();
                }
                int pos = VideoControllerView.this.videoMediaPlayer.getCurrentPosition();
                VideoControllerView.this.videoMediaPlayer.seekTo(pos -= VideoControllerView.this.rewindDuration);
                VideoControllerView.this.setProgress();
                VideoControllerView.this.show(3000);
            }
        });
        this.buttonManager.setPlaybackSpeedPopupMenuListener(new PlaybackSpeedPopupMenuListener(){

            @Override
            public void onSpeedSelected(float speed, String text) {
                VideoControllerView.this.buttonManager.updatePlaybackSpeedText(text);
                if (VideoControllerView.this.videoMediaPlayer != null) {
                    VideoControllerView.this.videoMediaPlayer.changePlaybackSpeed(speed);
                }
                VideoControllerView.this.hide();
            }

            @Override
            public void onPopupMenuDismissed() {
                VideoControllerView.this.show();
            }

            @Override
            public void onPopupMenuShown() {
                VideoControllerView.this.show(0);
            }
        });
    }

    private void setupXmlAttributes(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.VideoControllerView, 0, 0);
        this.buttonManager.setupDrawables(typedArray);
        this.setupProgressBar(typedArray);
        typedArray.recycle();
    }

    private void setupProgressBar(TypedArray a) {
        int color = a.getColor(R.styleable.VideoControllerView_progress_color, 0);
        if (color != 0) {
            this.progressBarColor = color;
        }
        this.progress.getProgressDrawable().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
        this.progress.getThumb().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
    }

    public void show() {
        this.show(3000);
    }

    private void setupButtonsVisibility() {
        if (this.videoMediaPlayer == null) {
            return;
        }
        this.buttonManager.setupButtonsVisibility();
    }

    private void show(int timeout) {
        if (!this.isShowing()) {
            this.buttonManager.requestStartPauseButtonFocus();
            this.setProgress();
            this.setupButtonsVisibility();
            this.setVisibility(0);
        }
        this.buttonManager.updatePausePlay();
        this.buttonManager.updateFullScreenDrawable();
        if (this.handler == null) {
            return;
        }
        this.handler.sendEmptyMessage(2);
        Message msg = this.handler.obtainMessage(1);
        if (timeout != 0) {
            this.handler.removeMessages(1);
            this.handler.sendMessageDelayed(msg, (long)timeout);
        } else {
            this.handler.removeMessages(1);
        }
    }

    public void updateFullScreenDrawable() {
        this.buttonManager.updateFullScreenDrawable();
    }

    private boolean isShowing() {
        return this.getVisibility() == 0;
    }

    private void hide() {
        try {
            this.setVisibility(4);
            if (this.handler != null) {
                this.handler.removeMessages(2);
            }
        }
        catch (IllegalArgumentException ignored) {
            Log.w((String)"MediaController", (String)"already removed");
        }
    }

    private static CharSequence stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        return String.format(Locale.getDefault(), "%d:%02d:%02d", hours, minutes, seconds);
    }

    private int setProgress() {
        if (this.videoMediaPlayer == null || this.isDragging) {
            return 0;
        }
        int position = this.videoMediaPlayer.getCurrentPosition();
        int duration = this.videoMediaPlayer.getDuration();
        if (this.progress != null) {
            if (duration > 0) {
                long pos = 1000L * (long)position / (long)duration;
                this.progress.setProgress((int)pos);
            }
            int percent = this.videoMediaPlayer.getBufferPercentage();
            this.progress.setSecondaryProgress(percent * 10);
        }
        if (this.endTime != null) {
            this.endTime.setText(VideoControllerView.stringForTime(duration));
        }
        if (this.currentTime != null) {
            this.currentTime.setText(VideoControllerView.stringForTime(position));
        }
        return position;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        this.performClick();
        this.show(3000);
        return true;
    }

    private void doPauseResume() {
        if (this.videoMediaPlayer == null) {
            return;
        }
        this.videoMediaPlayer.onPauseResume();
        this.buttonManager.updatePausePlay();
    }

    private void doToggleFullscreen() {
        if (this.videoMediaPlayer == null) {
            return;
        }
        this.videoMediaPlayer.toggleFullScreen();
    }

    public void setEnabled(boolean enabled) {
        this.buttonManager.setButtonsEnabled(enabled);
        if (this.progress != null) {
            this.progress.setEnabled(enabled);
        }
        this.setupButtonsVisibility();
        super.setEnabled(enabled);
    }

    public void onDetach() {
        this.seekListener = null;
        this.handler = null;
        this.videoMediaPlayer = null;
        this.mediaControllerListener = null;
    }

    public void setEnterFullscreenDrawable(Drawable enterFullscreenDrawable) {
        this.buttonManager.setEnterFullscreenDrawable(enterFullscreenDrawable);
    }

    public void setExitFullscreenDrawable(Drawable exitFullscreenDrawable) {
        this.buttonManager.setExitFullscreenDrawable(exitFullscreenDrawable);
    }

    public void setProgressBarColor(int progressBarColor) {
        this.progressBarColor = ContextCompat.getColor((Context)this.getContext(), (int)progressBarColor);
    }

    public void setPlayDrawable(Drawable playDrawable) {
        this.buttonManager.setPlayDrawable(playDrawable);
    }

    public void setPauseDrawable(Drawable pauseDrawable) {
        this.buttonManager.setPauseDrawable(pauseDrawable);
    }

    public void setFastForwardDuration(int fastForwardDuration) {
        this.fastForwardDuration = fastForwardDuration * 1000;
    }

    public void setRewindDuration(int rewindDuration) {
        this.rewindDuration = rewindDuration * 1000;
    }

    public void setFastForwardDrawable(Drawable fastForwardDrawable) {
        this.buttonManager.setFastForwardDrawable(fastForwardDrawable);
    }

    public void setRewindDrawable(Drawable rewindDrawable) {
        this.buttonManager.setRewindDrawable(rewindDrawable);
    }

    public void setPlaybackSpeedOptions(PlaybackSpeedOptions playbackSpeedOptions) {
        this.buttonManager.setPlaybackSpeedOptions(playbackSpeedOptions);
    }

    public void setOnMediaControllerListener(MediaControllerListener mediaControllerListener) {
        this.mediaControllerListener = mediaControllerListener;
    }

    public void init(final OrientationManager orientationManager, VideoMediaPlayer videoMediaPlayer, AttributeSet attrs) {
        this.setupXmlAttributes(attrs);
        this.videoMediaPlayer = videoMediaPlayer;
        this.buttonManager.setOrientationHelper(orientationManager);
        this.buttonManager.setVideoMediaPlayer(videoMediaPlayer);
        this.buttonManager.updatePausePlay();
        this.buttonManager.updateFullScreenDrawable();
        this.buttonManager.updateFastForwardDrawable();
        this.buttonManager.updateRewindDrawable();
        this.handler = new MessageHandler(this);
        this.getViewTreeObserver().addOnWindowFocusChangeListener(new ViewTreeObserver.OnWindowFocusChangeListener(){

            public void onWindowFocusChanged(boolean hasFocus) {
                if (orientationManager.isLandscape()) {
                    ((Activity)VideoControllerView.this.getContext()).getWindow().getDecorView().setSystemUiVisibility(5894);
                }
            }
        });
    }

    public void hideProgress() {
        this.currentTime.setVisibility(8);
        this.endTime.setVisibility(8);
        this.progress.setVisibility(8);
    }

    public void hideFullscreenButton() {
        this.buttonManager.hideFullscreenButton();
    }

    private class OnSeekChangeListener
    implements SeekBar.OnSeekBarChangeListener {
        private OnSeekChangeListener() {
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            VideoControllerView.this.show(3600000);
            VideoControllerView.this.isDragging = true;
            if (VideoControllerView.this.handler != null) {
                VideoControllerView.this.handler.removeMessages(2);
            }
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (VideoControllerView.this.videoMediaPlayer == null) {
                return;
            }
            if (!fromUser) {
                return;
            }
            long duration = VideoControllerView.this.videoMediaPlayer.getDuration();
            long newPosition = duration * (long)progress / 1000L;
            VideoControllerView.this.videoMediaPlayer.seekTo((int)newPosition);
            if (VideoControllerView.this.currentTime != null) {
                VideoControllerView.this.currentTime.setText(VideoControllerView.stringForTime((int)newPosition));
            }
            if (VideoControllerView.this.mediaControllerListener != null) {
                VideoControllerView.this.mediaControllerListener.onSeekBarProgressChanged(newPosition);
            }
            VideoControllerView.this.videoMediaPlayer.hideThumbnail();
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            VideoControllerView.this.isDragging = false;
            VideoControllerView.this.setProgress();
            VideoControllerView.this.buttonManager.updatePausePlay();
            VideoControllerView.this.show(3000);
            if (VideoControllerView.this.handler != null) {
                VideoControllerView.this.handler.sendEmptyMessage(2);
            }
        }
    }

    private static class MessageHandler
    extends Handler {
        private final WeakReference<VideoControllerView> view;

        MessageHandler(VideoControllerView view) {
            this.view = new WeakReference<VideoControllerView>(view);
        }

        public void handleMessage(Message msg) {
            VideoControllerView view = (VideoControllerView)((Object)this.view.get());
            if (view == null || view.videoMediaPlayer == null) {
                return;
            }
            if (msg.what == 1) {
                view.hide();
            } else {
                int position = view.setProgress();
                if (!view.isDragging && view.isShowing() && view.videoMediaPlayer.isPlaying()) {
                    Message message = this.obtainMessage(2);
                    this.sendMessageDelayed(message, 1000 - position % 1000);
                }
            }
        }
    }
}

