/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import bg.devlabs.fullscreenvideoview.Arguments;
import bg.devlabs.fullscreenvideoview.BitmapScaler;
import bg.devlabs.fullscreenvideoview.R;
import bg.devlabs.fullscreenvideoview.VideoControllerView;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.VideoSurfaceView;
import bg.devlabs.fullscreenvideoview.listener.FullscreenVideoViewException;
import bg.devlabs.fullscreenvideoview.listener.OnErrorListener;
import bg.devlabs.fullscreenvideoview.listener.OnVideoCompletedListener;
import bg.devlabs.fullscreenvideoview.listener.mediacontroller.MediaControllerListener;
import bg.devlabs.fullscreenvideoview.orientation.LandscapeOrientation;
import bg.devlabs.fullscreenvideoview.orientation.OrientationManager;
import bg.devlabs.fullscreenvideoview.orientation.PortraitOrientation;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedOptions;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class FullscreenVideoView
extends FrameLayout {
    @Nullable
    private VideoSurfaceView surfaceView;
    @Nullable
    private SurfaceHolder surfaceHolder;
    @Nullable
    private ProgressBar progressBar;
    @Nullable
    private ImageView thumbnailImageView;
    @Nullable
    private VideoControllerView controller;
    @Nullable
    private VideoMediaPlayer videoMediaPlayer;
    private boolean isMediaPlayerPrepared;
    @Nullable
    private OrientationManager orientationManager;
    private SurfaceHolder.Callback surfaceHolderCallback;
    private boolean isPaused;
    private int previousOrientation;
    private int seekToTimeMillis;
    @Nullable
    private OnErrorListener onErrorListener;
    @Nullable
    private AttributeSet attrs = null;
    private Arguments args = new Arguments();
    @Nullable
    private OnVideoCompletedListener onVideoCompletedListener;

    public FullscreenVideoView(@NonNull Context context) {
        super(context);
        this.init(null);
    }

    public FullscreenVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.attrs = attrs;
        this.init(attrs);
    }

    public FullscreenVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.attrs = attrs;
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.findChildViews();
        if (!this.isInEditMode()) {
            this.videoMediaPlayer = new VideoMediaPlayer(this);
            this.orientationManager = new OrientationManager(this.getContext(), this);
            this.orientationManager.enable();
        }
        this.setUpSurfaceHolder();
        if (this.controller != null) {
            this.controller.init(this.orientationManager, this.videoMediaPlayer, attrs);
        }
        this.setupProgressBarColor();
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.initOnBackPressedListener();
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                view.performClick();
                if (FullscreenVideoView.this.controller != null) {
                    FullscreenVideoView.this.controller.show();
                }
                return false;
            }
        });
    }

    private void setUpSurfaceHolder() {
        if (this.surfaceView != null) {
            this.surfaceHolderCallback = new SurfaceHolder.Callback(){

                public void surfaceCreated(SurfaceHolder holder) {
                    if (FullscreenVideoView.this.videoMediaPlayer != null) {
                        FullscreenVideoView.this.videoMediaPlayer.setDisplay(FullscreenVideoView.this.surfaceHolder);
                    }
                }

                public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                }

                public void surfaceDestroyed(SurfaceHolder holder) {
                    if (FullscreenVideoView.this.videoMediaPlayer != null && FullscreenVideoView.this.isMediaPlayerPrepared) {
                        FullscreenVideoView.this.videoMediaPlayer.pause();
                    }
                }
            };
            this.surfaceHolder = this.surfaceView.getHolder();
            this.surfaceHolder.addCallback(this.surfaceHolderCallback);
        }
    }

    private void findChildViews() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(R.layout.fullscreen_video_view, (ViewGroup)this, true);
        this.surfaceView = (VideoSurfaceView)this.findViewById(R.id.surface_view);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.controller = (VideoControllerView)this.findViewById(R.id.video_controller);
        this.thumbnailImageView = (ImageView)this.findViewById(R.id.thumbnail_image_view);
    }

    private void initOnBackPressedListener() {
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                return event.getAction() == 1 && keyCode == 4 && FullscreenVideoView.this.orientationManager != null && FullscreenVideoView.this.orientationManager.shouldHandleOnBackPressed();
            }
        });
    }

    public FullscreenVideoView videoFile(File videoFile) {
        this.setupMediaPlayer(videoFile.getPath());
        return this;
    }

    public FullscreenVideoView videoUrl(String videoUrl) {
        this.setupMediaPlayer(videoUrl);
        return this;
    }

    public FullscreenVideoView enableAutoStart() {
        if (this.videoMediaPlayer != null) {
            this.videoMediaPlayer.enableAutoStart();
            this.args.autoStartEnabled = true;
        }
        return this;
    }

    public FullscreenVideoView enterFullscreenDrawable(@NonNull Drawable drawable2) {
        this.controller.setEnterFullscreenDrawable(drawable2);
        this.args.enterFullscreenDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView enterFullscreenDrawable(@DrawableRes int drawableResId) {
        return this.enterFullscreenDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView exitFullscreenDrawable(@NonNull Drawable drawable2) {
        this.controller.setExitFullscreenDrawable(drawable2);
        this.args.exitFullscreenDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView exitFullscreenDrawable(@DrawableRes int drawableResId) {
        return this.exitFullscreenDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView playDrawable(@NonNull Drawable drawable2) {
        this.controller.setPlayDrawable(drawable2);
        this.args.playDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView playDrawable(@DrawableRes int drawableResId) {
        return this.playDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView pauseDrawable(@NonNull Drawable drawable2) {
        this.controller.setPauseDrawable(drawable2);
        this.args.pauseDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView pauseDrawable(@DrawableRes int drawableResId) {
        return this.pauseDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView fastForwardDrawable(@NonNull Drawable drawable2) {
        this.controller.setFastForwardDrawable(drawable2);
        this.args.fastForwardDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView fastForwardDrawable(@DrawableRes int drawableResId) {
        return this.fastForwardDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView rewindDrawable(@NonNull Drawable drawable2) {
        this.controller.setRewindDrawable(drawable2);
        this.args.rewindDrawable = drawable2;
        return this;
    }

    public FullscreenVideoView rewindDrawable(@DrawableRes int drawableResId) {
        return this.rewindDrawable(this.getDrawable(drawableResId));
    }

    public FullscreenVideoView progressBarColor(int progressBarColor) {
        this.controller.setProgressBarColor(progressBarColor);
        this.args.progressBarColor = progressBarColor;
        return this;
    }

    public FullscreenVideoView fastForwardSeconds(int fastForwardSeconds) {
        this.controller.setFastForwardDuration(fastForwardSeconds);
        this.args.fastForwardSeconds = fastForwardSeconds;
        return this;
    }

    public FullscreenVideoView rewindSeconds(int rewindSeconds) {
        this.controller.setRewindDuration(rewindSeconds);
        this.args.rewindSeconds = rewindSeconds;
        return this;
    }

    public FullscreenVideoView landscapeOrientation(LandscapeOrientation landscapeOrientation) {
        this.orientationManager.setLandscapeOrientation(landscapeOrientation);
        this.args.landscapeOrientation = landscapeOrientation;
        return this;
    }

    public FullscreenVideoView portraitOrientation(PortraitOrientation portraitOrientation) {
        this.orientationManager.setPortraitOrientation(portraitOrientation);
        this.args.portraitOrientation = portraitOrientation;
        return this;
    }

    public FullscreenVideoView disablePause() {
        this.videoMediaPlayer.disablePause();
        this.args.disablePause = true;
        return this;
    }

    public FullscreenVideoView addSeekForwardButton() {
        this.videoMediaPlayer.addSeekForwardButton();
        this.args.addSeekForwardButton = true;
        return this;
    }

    public FullscreenVideoView addSeekBackwardButton() {
        this.videoMediaPlayer.addSeekBackwardButton();
        this.args.addSeekBackwardButton = true;
        return this;
    }

    @RequiresApi(value=23)
    public FullscreenVideoView addPlaybackSpeedButton() {
        this.videoMediaPlayer.addPlaybackSpeedButton();
        this.args.addPlaybackSpeedButton = true;
        return this;
    }

    public FullscreenVideoView playbackSpeedOptions(PlaybackSpeedOptions playbackSpeedOptions) {
        this.controller.setPlaybackSpeedOptions(playbackSpeedOptions);
        this.args.playbackSpeedOptions = playbackSpeedOptions;
        return this;
    }

    public FullscreenVideoView thumbnail(int thumbnailResId) {
        if (this.thumbnailImageView != null) {
            Bitmap thumbnail = BitmapScaler.scaleImage(this.getResources(), thumbnailResId);
            this.thumbnailImageView.setImageBitmap(thumbnail);
            this.args.thumbnailResId = thumbnailResId;
        }
        return this;
    }

    public FullscreenVideoView hideProgress() {
        this.controller.hideProgress();
        this.args.hideProgress = true;
        return this;
    }

    public FullscreenVideoView hideFullscreenButton() {
        this.controller.hideFullscreenButton();
        this.args.hideFullscreenButton = true;
        return this;
    }

    public FullscreenVideoView addOnErrorListener(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
        return this;
    }

    public FullscreenVideoView addOnVideoCompletedListener(OnVideoCompletedListener listener) {
        this.onVideoCompletedListener = listener;
        return this;
    }

    public FullscreenVideoView mediaControllerListener(MediaControllerListener mediaControllerListener) {
        this.controller.setOnMediaControllerListener(mediaControllerListener);
        return this;
    }

    public FullscreenVideoView setSeekToTimeMillis(int timeMillis) {
        this.seekToTimeMillis = timeMillis;
        this.args.seekToTimeMillis = timeMillis;
        return this;
    }

    private Drawable getDrawable(int drawableResId) {
        return ContextCompat.getDrawable((Context)this.getContext(), (int)drawableResId);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ImageButton fullscreenButton = (ImageButton)this.findViewById(R.id.fullscreen_media_button);
        String fullscreenButtonTag = (String)fullscreenButton.getTag();
        if (!Objects.equals(fullscreenButtonTag, "view_tag:clicked")) {
            return;
        }
        if (this.orientationManager == null) {
            return;
        }
        if (this.previousOrientation == newConfig.orientation) {
            return;
        }
        this.previousOrientation = newConfig.orientation;
        if (newConfig.orientation == 2) {
            this.orientationManager.activateFullscreen();
            this.setFocusable(true);
            this.setFocusableInTouchMode(true);
            this.requestFocus();
        } else if (newConfig.orientation == 1) {
            this.orientationManager.exitFullscreen();
            fullscreenButton.setTag(null);
        }
    }

    protected void onDetachedFromWindow() {
        this.handleOnDetach();
        super.onDetachedFromWindow();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.isPaused = visibility != 0;
    }

    private void handleOnDetach() {
        if (this.controller != null) {
            this.controller.onDetach();
            this.controller = null;
        }
        if (this.orientationManager != null) {
            this.orientationManager.disable();
            this.orientationManager = null;
        }
        if (this.videoMediaPlayer != null) {
            this.videoMediaPlayer.onDetach();
            this.videoMediaPlayer = null;
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback(this.surfaceHolderCallback);
            this.surfaceHolder.getSurface().release();
            this.surfaceHolder = null;
        }
        if (this.surfaceView != null) {
            this.surfaceView.invalidate();
            this.surfaceView.destroyDrawingCache();
            this.surfaceView = null;
        }
        this.progressBar = null;
        this.surfaceHolderCallback = null;
        this.attrs = null;
        this.setOnKeyListener(null);
        this.setOnTouchListener(null);
        this.onErrorListener = null;
        this.detachAllViewsFromParent();
    }

    public void setupMediaPlayer(String videoPath) {
        block5: {
            this.showProgress();
            try {
                if (this.videoMediaPlayer != null) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(2).setLegacyStreamType(3).build();
                        this.videoMediaPlayer.setAudioAttributes(audioAttributes);
                    } else {
                        this.videoMediaPlayer.setAudioStreamType(3);
                    }
                    this.videoMediaPlayer.setDataSource(videoPath);
                    this.videoMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                        public void onPrepared(MediaPlayer mediaPlayer) {
                            FullscreenVideoView.this.hideProgressBar();
                            int videoWidth = FullscreenVideoView.this.videoMediaPlayer.getVideoWidth();
                            int videoHeight = FullscreenVideoView.this.videoMediaPlayer.getVideoHeight();
                            if (FullscreenVideoView.this.surfaceView != null) {
                                FullscreenVideoView.this.surfaceView.updateLayoutParams(videoWidth, videoHeight);
                            }
                            if (!FullscreenVideoView.this.isPaused) {
                                FullscreenVideoView.this.isMediaPlayerPrepared = true;
                                if (mediaPlayer != null && FullscreenVideoView.this.videoMediaPlayer.isAutoStartEnabled()) {
                                    mediaPlayer.start();
                                    FullscreenVideoView.this.hideThumbnail();
                                }
                            }
                            FullscreenVideoView.this.videoMediaPlayer.seekTo(FullscreenVideoView.this.seekToTimeMillis);
                        }
                    });
                    this.videoMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                        public boolean onError(MediaPlayer mp, int what, int extra) {
                            FullscreenVideoView.this.handleMediaPlayerError(what);
                            return false;
                        }
                    });
                    this.videoMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                        public void onCompletion(MediaPlayer mediaPlayer) {
                            if (FullscreenVideoView.this.onVideoCompletedListener == null) {
                                return;
                            }
                            FullscreenVideoView.this.onVideoCompletedListener.onFinished();
                        }
                    });
                    this.videoMediaPlayer.prepareAsync();
                }
            }
            catch (IOException exception) {
                if (this.onErrorListener == null) break block5;
                FullscreenVideoViewException fullscreenVideoViewException = new FullscreenVideoViewException(exception.getLocalizedMessage());
                this.onErrorListener.onError(fullscreenVideoViewException);
            }
        }
    }

    private void handleMediaPlayerError(int what) {
        if (this.onErrorListener == null) {
            return;
        }
        switch (what) {
            case -1004: {
                this.onErrorListener.onError(new FullscreenVideoViewException(-1004, this.getContext().getString(R.string.media_error_io)));
                break;
            }
            case -1007: {
                this.onErrorListener.onError(new FullscreenVideoViewException(-1007, this.getContext().getString(R.string.media_error_malformed)));
                break;
            }
            case 200: {
                this.onErrorListener.onError(new FullscreenVideoViewException(200, this.getContext().getString(R.string.media_error_not_valid_for_progressive_playback)));
                break;
            }
            case 100: {
                this.onErrorListener.onError(new FullscreenVideoViewException(100, this.getContext().getString(R.string.media_error_server_died)));
                break;
            }
            case -110: {
                this.onErrorListener.onError(new FullscreenVideoViewException(-110, this.getContext().getString(R.string.media_error_timed_out)));
                break;
            }
            case 1: {
                this.onErrorListener.onError(new FullscreenVideoViewException(1, this.getContext().getString(R.string.media_error_unknown)));
                break;
            }
            case -1010: {
                this.onErrorListener.onError(new FullscreenVideoViewException(-1010, this.getContext().getString(R.string.media_error_unsupported)));
                break;
            }
            default: {
                this.onErrorListener.onError(new FullscreenVideoViewException(1000, this.getContext().getString(R.string.media_error_general)));
            }
        }
    }

    void hideThumbnail() {
        if (this.thumbnailImageView != null && this.thumbnailImageView.getVisibility() == 0) {
            this.thumbnailImageView.setVisibility(8);
        }
    }

    private void setupProgressBarColor() {
        int shortAnimTime = this.getResources().getInteger(0x10E0000);
        if (this.progressBar != null) {
            this.progressBar.animate().setDuration((long)shortAnimTime);
        }
    }

    private void hideProgressBar() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(4);
        }
    }

    private void showProgress() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
    }

    public void toggleFullscreen() {
        if (this.orientationManager != null) {
            this.orientationManager.toggleFullscreen();
        }
    }

    public void onOrientationChanged() {
        if (this.controller != null) {
            this.controller.updateFullScreenDrawable();
        }
        if (this.surfaceView != null && this.videoMediaPlayer != null) {
            this.surfaceView.updateLayoutParams(this.videoMediaPlayer.getVideoWidth(), this.videoMediaPlayer.getVideoHeight());
        }
    }

    public void pause() {
        if (this.videoMediaPlayer != null) {
            this.videoMediaPlayer.pause();
        }
    }

    public void play() {
        if (this.videoMediaPlayer != null) {
            this.videoMediaPlayer.start();
            this.hideThumbnail();
        }
    }

    public void changeUrl(@NonNull String url) {
        int thumbnailResId;
        PlaybackSpeedOptions playbackSpeedOptions;
        PortraitOrientation portraitOrientation;
        LandscapeOrientation landscapeOrientation;
        int rewindSeconds;
        int fastForwardSeconds;
        int progressBarColor;
        Drawable rewindDrawable;
        Drawable fastForwardDrawable;
        Drawable pauseDrawable;
        Drawable playDrawable;
        Drawable exitFullscreenDrawable;
        Drawable enterFullscreenDrawable;
        this.handleOnDetach();
        this.init(this.attrs);
        this.setupMediaPlayer(url);
        if (this.args.autoStartEnabled) {
            this.enableAutoStart();
        }
        if ((enterFullscreenDrawable = this.args.enterFullscreenDrawable) != null) {
            this.enterFullscreenDrawable(enterFullscreenDrawable);
        }
        if ((exitFullscreenDrawable = this.args.exitFullscreenDrawable) != null) {
            this.exitFullscreenDrawable(exitFullscreenDrawable);
        }
        if ((playDrawable = this.args.playDrawable) != null) {
            this.playDrawable(playDrawable);
        }
        if ((pauseDrawable = this.args.pauseDrawable) != null) {
            this.pauseDrawable(pauseDrawable);
        }
        if ((fastForwardDrawable = this.args.fastForwardDrawable) != null) {
            this.fastForwardDrawable(fastForwardDrawable);
        }
        if ((rewindDrawable = this.args.rewindDrawable) != null) {
            this.rewindDrawable(rewindDrawable);
        }
        if ((progressBarColor = this.args.progressBarColor) != -1) {
            this.progressBarColor(progressBarColor);
        }
        if ((fastForwardSeconds = this.args.fastForwardSeconds) != -1) {
            this.fastForwardSeconds(fastForwardSeconds);
        }
        if ((rewindSeconds = this.args.rewindSeconds) != -1) {
            this.rewindSeconds(rewindSeconds);
        }
        if ((landscapeOrientation = this.args.landscapeOrientation) != null) {
            this.landscapeOrientation(landscapeOrientation);
        }
        if ((portraitOrientation = this.args.portraitOrientation) != null) {
            this.portraitOrientation(portraitOrientation);
        }
        if (this.args.disablePause) {
            this.disablePause();
        }
        if (this.args.addSeekForwardButton) {
            this.addSeekForwardButton();
        }
        if (this.args.addSeekBackwardButton) {
            this.addSeekBackwardButton();
        }
        if (this.args.addPlaybackSpeedButton && Build.VERSION.SDK_INT >= 23) {
            this.addPlaybackSpeedButton();
        }
        if ((playbackSpeedOptions = this.args.playbackSpeedOptions) != null) {
            this.playbackSpeedOptions(playbackSpeedOptions);
        }
        if ((thumbnailResId = this.args.thumbnailResId) != -1) {
            this.thumbnail(thumbnailResId);
        }
        if (this.args.hideProgress) {
            this.hideProgress();
        }
        if (this.args.hideFullscreenButton) {
            this.hideFullscreenButton();
        }
        int timeMillis = this.args.seekToTimeMillis;
        if (this.args.seekToTimeMillis != -1) {
            this.setSeekToTimeMillis(timeMillis);
        }
    }
}

