/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import bg.devlabs.fullscreenvideoview.BitmapScaler;
import bg.devlabs.fullscreenvideoview.Builder;
import bg.devlabs.fullscreenvideoview.R;
import bg.devlabs.fullscreenvideoview.VideoControllerView;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.VideoSurfaceView;
import bg.devlabs.fullscreenvideoview.listener.FullscreenVideoViewException;
import bg.devlabs.fullscreenvideoview.listener.OnErrorListener;
import bg.devlabs.fullscreenvideoview.orientation.OrientationManager;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class FullscreenVideoView
extends FrameLayout {
    @Nullable
    private VideoSurfaceView surfaceView;
    @Nullable
    private SurfaceHolder surfaceHolder;
    @Nullable
    private ProgressBar progressBar;
    @Nullable
    private ImageView thumbnailImageView;
    @Nullable
    private VideoControllerView controller;
    @Nullable
    private VideoMediaPlayer videoMediaPlayer;
    private boolean isMediaPlayerPrepared;
    @Nullable
    private OrientationManager orientationManager;
    private SurfaceHolder.Callback surfaceHolderCallback;
    private boolean isPaused;
    private int previousOrientation;
    @Nullable
    private OnErrorListener onErrorListener;

    public FullscreenVideoView(@NonNull Context context) {
        super(context);
        this.init(null);
    }

    public FullscreenVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public FullscreenVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.findChildViews();
        if (!this.isInEditMode()) {
            this.videoMediaPlayer = new VideoMediaPlayer(this);
            this.orientationManager = new OrientationManager(this.getContext(), this);
            this.orientationManager.enable();
        }
        this.setupSurfaceHolder();
        if (this.controller != null) {
            this.controller.init(this.orientationManager, this.videoMediaPlayer, attrs);
        }
        this.setupProgressBarColor();
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.initOnBackPressedListener();
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                view.performClick();
                if (FullscreenVideoView.this.controller != null) {
                    FullscreenVideoView.this.controller.show();
                }
                return false;
            }
        });
    }

    private void setupSurfaceHolder() {
        if (this.surfaceView != null) {
            this.surfaceHolderCallback = new SurfaceHolder.Callback(){

                public void surfaceCreated(SurfaceHolder holder) {
                    if (FullscreenVideoView.this.videoMediaPlayer != null) {
                        FullscreenVideoView.this.videoMediaPlayer.setDisplay(FullscreenVideoView.this.surfaceHolder);
                    }
                }

                public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                }

                public void surfaceDestroyed(SurfaceHolder holder) {
                    if (FullscreenVideoView.this.videoMediaPlayer != null && FullscreenVideoView.this.isMediaPlayerPrepared) {
                        FullscreenVideoView.this.videoMediaPlayer.pause();
                    }
                }
            };
            this.surfaceHolder = this.surfaceView.getHolder();
            this.surfaceHolder.addCallback(this.surfaceHolderCallback);
        }
    }

    private void findChildViews() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(R.layout.fullscreen_video_view, (ViewGroup)this, true);
        this.surfaceView = (VideoSurfaceView)this.findViewById(R.id.surface_view);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.controller = (VideoControllerView)this.findViewById(R.id.video_controller);
        this.thumbnailImageView = (ImageView)this.findViewById(R.id.thumbnail_image_view);
    }

    private void initOnBackPressedListener() {
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                return event.getAction() == 1 && keyCode == 4 && FullscreenVideoView.this.orientationManager != null && FullscreenVideoView.this.orientationManager.shouldHandleOnBackPressed();
            }
        });
    }

    public Builder videoFile(File videoFile) {
        return new Builder(this, this.controller, this.orientationManager, this.videoMediaPlayer).videoFile(videoFile);
    }

    public Builder videoUrl(String videoUrl) {
        return new Builder(this, this.controller, this.orientationManager, this.videoMediaPlayer).videoUrl(videoUrl);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        ImageButton fullscreenButton = (ImageButton)this.findViewById(R.id.fullscreen_media_button);
        String fullscreenButtonTag = (String)fullscreenButton.getTag();
        if (!Objects.equals(fullscreenButtonTag, "view_tag:clicked")) {
            return;
        }
        if (this.orientationManager == null) {
            return;
        }
        if (this.previousOrientation == newConfig.orientation) {
            return;
        }
        this.previousOrientation = newConfig.orientation;
        if (newConfig.orientation == 2) {
            this.orientationManager.activateFullscreen();
            this.setFocusable(true);
            this.setFocusableInTouchMode(true);
            this.requestFocus();
        } else if (newConfig.orientation == 1) {
            this.orientationManager.exitFullscreen();
            fullscreenButton.setTag(null);
        }
    }

    protected void onDetachedFromWindow() {
        this.handleOnDetach();
        super.onDetachedFromWindow();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.isPaused = visibility != 0;
    }

    private void handleOnDetach() {
        if (this.controller != null) {
            this.controller.onDetach();
        }
        if (this.orientationManager != null) {
            this.orientationManager.disable();
        }
        if (this.videoMediaPlayer != null) {
            this.videoMediaPlayer.onDetach();
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback(this.surfaceHolderCallback);
            this.surfaceHolder.getSurface().release();
        }
        if (this.surfaceView != null) {
            this.surfaceView.invalidate();
            this.surfaceView.destroyDrawingCache();
        }
        this.controller = null;
        this.orientationManager = null;
        this.videoMediaPlayer = null;
        this.surfaceHolder = null;
        this.surfaceView = null;
        this.progressBar = null;
        this.setOnKeyListener(null);
        this.setOnTouchListener(null);
        this.onErrorListener = null;
    }

    public void setupMediaPlayer(String videoPath) {
        block5: {
            this.showProgress();
            try {
                if (this.videoMediaPlayer != null) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(2).setLegacyStreamType(3).build();
                        this.videoMediaPlayer.setAudioAttributes(audioAttributes);
                    } else {
                        this.videoMediaPlayer.setAudioStreamType(3);
                    }
                    this.videoMediaPlayer.setDataSource(videoPath);
                    this.videoMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                        public void onPrepared(MediaPlayer mediaPlayer) {
                            FullscreenVideoView.this.hideProgressBar();
                            int videoWidth = FullscreenVideoView.this.videoMediaPlayer.getVideoWidth();
                            int videoHeight = FullscreenVideoView.this.videoMediaPlayer.getVideoHeight();
                            if (FullscreenVideoView.this.surfaceView != null) {
                                FullscreenVideoView.this.surfaceView.updateLayoutParams(videoWidth, videoHeight);
                            }
                            if (!FullscreenVideoView.this.isPaused) {
                                FullscreenVideoView.this.isMediaPlayerPrepared = true;
                                if (mediaPlayer != null && FullscreenVideoView.this.videoMediaPlayer.isAutoStartEnabled()) {
                                    mediaPlayer.start();
                                    FullscreenVideoView.this.hideThumbnail();
                                }
                            }
                        }
                    });
                    this.videoMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                        public boolean onError(MediaPlayer mp, int what, int extra) {
                            FullscreenVideoView.this.handleMediaPlayerError(what);
                            return false;
                        }
                    });
                    this.videoMediaPlayer.prepareAsync();
                }
            }
            catch (IOException exception) {
                if (this.onErrorListener == null) break block5;
                FullscreenVideoViewException fullscreenVideoViewException = new FullscreenVideoViewException(exception.getLocalizedMessage());
                this.onErrorListener.onError(fullscreenVideoViewException);
            }
        }
    }

    private void handleMediaPlayerError(int what) {
        if (this.onErrorListener == null) {
            return;
        }
        switch (what) {
            case -1004: {
                this.onErrorListener.onError(new FullscreenVideoViewException(-1004, this.getContext().getString(R.string.media_error_io)));
                break;
            }
            case -1007: {
                this.onErrorListener.onError(new FullscreenVideoViewException(-1007, this.getContext().getString(R.string.media_error_malformed)));
                break;
            }
            case 200: {
                this.onErrorListener.onError(new FullscreenVideoViewException(200, this.getContext().getString(R.string.media_error_not_valid_for_progressive_playback)));
                break;
            }
            case 100: {
                this.onErrorListener.onError(new FullscreenVideoViewException(100, this.getContext().getString(R.string.media_error_server_died)));
                break;
            }
            case -110: {
                this.onErrorListener.onError(new FullscreenVideoViewException(-110, this.getContext().getString(R.string.media_error_timed_out)));
                break;
            }
            case 1: {
                this.onErrorListener.onError(new FullscreenVideoViewException(1, this.getContext().getString(R.string.media_error_unknown)));
                break;
            }
            case -1010: {
                this.onErrorListener.onError(new FullscreenVideoViewException(-1010, this.getContext().getString(R.string.media_error_unsupported)));
                break;
            }
            default: {
                this.onErrorListener.onError(new FullscreenVideoViewException(1000, this.getContext().getString(R.string.media_error_general)));
            }
        }
    }

    void hideThumbnail() {
        if (this.thumbnailImageView != null && this.thumbnailImageView.getVisibility() == 0) {
            this.thumbnailImageView.setVisibility(8);
        }
    }

    private void setupProgressBarColor() {
        int shortAnimTime = this.getResources().getInteger(0x10E0000);
        if (this.progressBar != null) {
            this.progressBar.animate().setDuration((long)shortAnimTime);
        }
    }

    private void hideProgressBar() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(4);
        }
    }

    private void showProgress() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
    }

    public void toggleFullscreen() {
        if (this.orientationManager != null) {
            this.orientationManager.toggleFullscreen();
        }
    }

    public void enableAutoStart() {
        if (this.videoMediaPlayer != null) {
            this.videoMediaPlayer.enableAutoStart();
        }
    }

    public void onOrientationChanged() {
        if (this.controller != null) {
            this.controller.updateFullScreenDrawable();
        }
        if (this.surfaceView != null && this.videoMediaPlayer != null) {
            this.surfaceView.updateLayoutParams(this.videoMediaPlayer.getVideoWidth(), this.videoMediaPlayer.getVideoHeight());
        }
    }

    public void setVideoThumbnail(int thumbnailResId) {
        if (this.thumbnailImageView != null) {
            Bitmap scaledBitmap = BitmapScaler.scaleImage(this.getResources(), thumbnailResId);
            this.thumbnailImageView.setImageBitmap(scaledBitmap);
        }
    }

    public void pause() {
        if (this.videoMediaPlayer != null) {
            this.videoMediaPlayer.pause();
        }
    }

    public void play() {
        if (this.videoMediaPlayer != null) {
            this.videoMediaPlayer.start();
            this.hideThumbnail();
        }
    }

    public void hideProgress() {
        if (this.controller != null) {
            this.controller.hideProgress();
        }
    }

    public void hideFullscreenButton() {
        if (this.controller != null) {
            this.controller.hideFullscreenButton();
        }
    }

    public void addOnErrorListener(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }
}

