/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import bg.devlabs.fullscreenvideoview.FullscreenVideoView;
import bg.devlabs.fullscreenvideoview.VideoControllerView;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.listener.OnErrorListener;
import bg.devlabs.fullscreenvideoview.listener.mediacontroller.MediaControllerListener;
import bg.devlabs.fullscreenvideoview.orientation.LandscapeOrientation;
import bg.devlabs.fullscreenvideoview.orientation.OrientationManager;
import bg.devlabs.fullscreenvideoview.orientation.PortraitOrientation;
import bg.devlabs.fullscreenvideoview.playbackspeed.PlaybackSpeedOptions;
import java.io.File;

public class Builder {
    private final FullscreenVideoView fullscreenVideoView;
    private final VideoControllerView controller;
    private final OrientationManager orientationManager;
    private final VideoMediaPlayer videoMediaPlayer;

    Builder(FullscreenVideoView fullscreenVideoView, VideoControllerView controller, OrientationManager orientationManager, VideoMediaPlayer videoMediaPlayer) {
        this.fullscreenVideoView = fullscreenVideoView;
        this.controller = controller;
        this.orientationManager = orientationManager;
        this.videoMediaPlayer = videoMediaPlayer;
    }

    public Builder videoFile(@NonNull File videoFile) {
        this.fullscreenVideoView.setupMediaPlayer(videoFile.getPath());
        return this;
    }

    public Builder videoUrl(@NonNull String videoUrl) {
        this.fullscreenVideoView.setupMediaPlayer(videoUrl);
        return this;
    }

    public Builder enableAutoStart() {
        this.fullscreenVideoView.enableAutoStart();
        return this;
    }

    public Builder enterFullscreenDrawable(@NonNull Drawable drawable) {
        this.controller.setEnterFullscreenDrawable(drawable);
        return this;
    }

    public Builder enterFullscreenDrawable(@DrawableRes int drawableResId) {
        return this.enterFullscreenDrawable(this.getDrawable(drawableResId));
    }

    public Builder exitFullscreenDrawable(@NonNull Drawable drawable) {
        this.controller.setExitFullscreenDrawable(drawable);
        return this;
    }

    public Builder exitFullscreenDrawable(@DrawableRes int drawableResId) {
        return this.exitFullscreenDrawable(this.getDrawable(drawableResId));
    }

    public Builder playDrawable(@NonNull Drawable drawable) {
        this.controller.setPlayDrawable(drawable);
        return this;
    }

    public Builder playDrawable(@DrawableRes int drawableResId) {
        return this.playDrawable(this.getDrawable(drawableResId));
    }

    public Builder pauseDrawable(@NonNull Drawable drawable) {
        this.controller.setPauseDrawable(drawable);
        return this;
    }

    public Builder pauseDrawable(@DrawableRes int drawableResId) {
        return this.pauseDrawable(this.getDrawable(drawableResId));
    }

    public Builder fastForwardDrawable(@NonNull Drawable drawable) {
        this.controller.setFastForwardDrawable(drawable);
        return this;
    }

    public Builder fastForwardDrawable(@DrawableRes int drawableResId) {
        return this.fastForwardDrawable(this.getDrawable(drawableResId));
    }

    public Builder rewindDrawable(@NonNull Drawable drawable) {
        this.controller.setRewindDrawable(drawable);
        return this;
    }

    public Builder rewindDrawable(@DrawableRes int drawableResId) {
        return this.rewindDrawable(this.getDrawable(drawableResId));
    }

    private Drawable getDrawable(int drawableResId) {
        Context context = this.fullscreenVideoView.getContext();
        return ContextCompat.getDrawable((Context)context, (int)drawableResId);
    }

    public Builder progressBarColor(int progressBarColor) {
        this.controller.setProgressBarColor(progressBarColor);
        return this;
    }

    public Builder fastForwardSeconds(int fastForwardSeconds) {
        this.controller.setFastForwardDuration(fastForwardSeconds);
        return this;
    }

    public Builder rewindSeconds(int rewindSeconds) {
        this.controller.setRewindDuration(rewindSeconds);
        return this;
    }

    public Builder landscapeOrientation(LandscapeOrientation landscapeOrientation) {
        this.orientationManager.setLandscapeOrientation(landscapeOrientation);
        return this;
    }

    public Builder portraitOrientation(PortraitOrientation portraitOrientation) {
        this.orientationManager.setPortraitOrientation(portraitOrientation);
        return this;
    }

    public Builder disablePause() {
        this.videoMediaPlayer.disablePause();
        return this;
    }

    public Builder addSeekForwardButton() {
        this.videoMediaPlayer.addSeekForwardButton();
        return this;
    }

    public Builder addSeekBackwardButton() {
        this.videoMediaPlayer.addSeekBackwardButton();
        return this;
    }

    @RequiresApi(value=23)
    public Builder addPlaybackSpeedButton() {
        this.videoMediaPlayer.addPlaybackSpeedButton();
        return this;
    }

    public Builder playbackSpeedOptions(PlaybackSpeedOptions playbackSpeedOptions) {
        this.controller.setPlaybackSpeedOptions(playbackSpeedOptions);
        return this;
    }

    public Builder thumbnail(int thumbnailResId) {
        this.fullscreenVideoView.setVideoThumbnail(thumbnailResId);
        return this;
    }

    public Builder hideProgress() {
        this.controller.hideProgress();
        return this;
    }

    public Builder hideFullscreenButton() {
        this.controller.hideFullscreenButton();
        return this;
    }

    public Builder addOnErrorListener(OnErrorListener onErrorListener) {
        this.fullscreenVideoView.addOnErrorListener(onErrorListener);
        return this;
    }

    public Builder mediaControllerListener(MediaControllerListener mediaControllerListener) {
        this.controller.setOnMediaControllerListener(mediaControllerListener);
        return this;
    }
}

