/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import bg.devlabs.fullscreenvideoview.DeviceDimensionsManager;

class VideoSurfaceView
extends SurfaceView {
    private int previousHeight;
    private int previousWidth;

    public VideoSurfaceView(Context context) {
        super(context);
    }

    public VideoSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VideoSurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void updateLayoutParams(int videoWidth, int videoHeight) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        this.resetLayoutParams(layoutParams);
        this.previousHeight = layoutParams.height;
        this.previousWidth = layoutParams.width;
        DeviceDimensionsManager deviceDimensionsManager = DeviceDimensionsManager.getInstance();
        Context context = this.getContext();
        int screenWidth = deviceDimensionsManager.getDisplayWidth(context);
        int screenHeight = deviceDimensionsManager.getDisplayHeight(context);
        FrameLayout.LayoutParams surfaceViewLayoutParams = (FrameLayout.LayoutParams)layoutParams;
        if ((float)videoHeight / (float)screenHeight > (float)videoWidth / (float)screenWidth) {
            surfaceViewLayoutParams.height = screenHeight;
            surfaceViewLayoutParams.width = (int)((float)videoWidth / (float)videoHeight * (float)screenHeight);
        } else {
            surfaceViewLayoutParams.width = screenWidth;
            surfaceViewLayoutParams.height = (int)((float)videoHeight / (float)videoWidth * (float)screenWidth);
        }
        surfaceViewLayoutParams.gravity = 17;
        this.setLayoutParams((ViewGroup.LayoutParams)surfaceViewLayoutParams);
    }

    private void resetLayoutParams(ViewGroup.LayoutParams layoutParams) {
        FrameLayout.LayoutParams frameLayoutParams = (FrameLayout.LayoutParams)layoutParams;
        frameLayoutParams.height = this.previousHeight;
        frameLayoutParams.width = this.previousWidth;
        this.setLayoutParams(layoutParams);
    }
}

