/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.annotation.TargetApi;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.support.annotation.Nullable;
import bg.devlabs.fullscreenvideoview.FullscreenVideoView;

class VideoMediaPlayer
extends MediaPlayer {
    @Nullable
    private FullscreenVideoView fullscreenVideoView;
    private boolean isAutoStartEnabled;
    private boolean canPause = true;
    private boolean showSeekBackwardButton = false;
    private boolean showSeekForwardButton = false;
    private boolean showPlaybackSpeedButton = false;

    VideoMediaPlayer(@Nullable FullscreenVideoView fullscreenVideoView) {
        this.fullscreenVideoView = fullscreenVideoView;
    }

    public int getBufferPercentage() {
        return 0;
    }

    public boolean canPause() {
        return this.canPause;
    }

    public boolean showSeekForwardButton() {
        return this.showSeekForwardButton;
    }

    public boolean showSeekBackwardButton() {
        return this.showSeekBackwardButton;
    }

    public boolean showPlaybackSpeedButton() {
        return this.showPlaybackSpeedButton;
    }

    public void toggleFullScreen() {
        if (this.fullscreenVideoView != null) {
            this.fullscreenVideoView.toggleFullscreen();
        }
    }

    public void onPauseResume() {
        if (this.isPlaying()) {
            this.pause();
        } else {
            this.start();
        }
    }

    public void onDetach() {
        this.fullscreenVideoView = null;
        this.setOnPreparedListener(null);
        this.stop();
        this.release();
    }

    public boolean isAutoStartEnabled() {
        return this.isAutoStartEnabled;
    }

    public void enableAutoStart() {
        this.isAutoStartEnabled = true;
    }

    public void setPauseEnabled(boolean canPause) {
        this.canPause = canPause;
    }

    public void addSeekForwardButton() {
        this.showSeekForwardButton = true;
    }

    public void addSeekBackwardButton() {
        this.showSeekBackwardButton = true;
    }

    public void addPlaybackSpeedButton() {
        this.showPlaybackSpeedButton = true;
    }

    void setCanSeekBackward(boolean canSeekBackward) {
        this.showSeekBackwardButton = canSeekBackward;
    }

    void setCanSeekForward(boolean canSeekForward) {
        this.showSeekForwardButton = canSeekForward;
    }

    @TargetApi(value=23)
    public void changePlaybackSpeed(float speed) {
        PlaybackParams playbackParams = new PlaybackParams();
        playbackParams.setSpeed(speed);
        this.setPlaybackParams(playbackParams);
    }
}

