/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.PopupMenu;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.SeekBar;
import android.widget.TextView;
import bg.devlabs.fullscreenvideoview.ButtonHelper;
import bg.devlabs.fullscreenvideoview.PlaybackSpeedOptions;
import bg.devlabs.fullscreenvideoview.PlaybackSpeedPopupMenu;
import bg.devlabs.fullscreenvideoview.R;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.orientation.OrientationHelper;
import java.lang.ref.WeakReference;
import java.util.Locale;

class VideoControllerView
extends FrameLayout {
    private static final String TAG = "VideoControllerView";
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    @Nullable
    private VideoMediaPlayer videoMediaPlayer;
    private TextView endTime;
    private TextView currentTime;
    private boolean isDragging;
    private PlaybackSpeedPopupMenu popupMenu;
    @Nullable
    private Handler handler = new MessageHandler(this);
    private SeekBar progress;
    private ImageButton startPauseButton;
    private ImageButton ffwdButton;
    private ImageButton rewButton;
    private TextView playbackSpeedButton;
    @Nullable
    private View.OnClickListener pauseListener = new View.OnClickListener(){

        public void onClick(View v) {
            VideoControllerView.this.doPauseResume();
            VideoControllerView.this.show(3000);
        }
    };
    @Nullable
    private View.OnClickListener fullscreenListener = new View.OnClickListener(){

        public void onClick(View view) {
            VideoControllerView.this.doToggleFullscreen();
            VideoControllerView.this.show(3000);
        }
    };
    @Nullable
    private SeekBar.OnSeekBarChangeListener seekListener = new OnSeekChangeListener();
    @Nullable
    private View.OnClickListener rewListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (VideoControllerView.this.videoMediaPlayer == null) {
                return;
            }
            int pos = VideoControllerView.this.videoMediaPlayer.getCurrentPosition();
            VideoControllerView.this.videoMediaPlayer.seekTo(pos -= VideoControllerView.this.rewindDuration);
            VideoControllerView.this.setProgress();
            VideoControllerView.this.show(3000);
        }
    };
    @Nullable
    private View.OnClickListener ffwdListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (VideoControllerView.this.videoMediaPlayer == null) {
                return;
            }
            int pos = VideoControllerView.this.videoMediaPlayer.getCurrentPosition();
            VideoControllerView.this.videoMediaPlayer.seekTo(pos += VideoControllerView.this.fastForwardDuration);
            VideoControllerView.this.setProgress();
            VideoControllerView.this.show(3000);
        }
    };
    @Nullable
    private View.OnClickListener playbackSpeedListener = new View.OnClickListener(){

        public void onClick(View v) {
            VideoControllerView.this.popupMenu.setOnSpeedSelectedListener(new PlaybackSpeedPopupMenu.OnSpeedSelectedListener(){

                @Override
                public void onSpeedSelected(float speed, String text) {
                    VideoControllerView.this.buttonHelper.updatePlaybackSpeedText(text);
                    VideoControllerView.this.videoMediaPlayer.changePlaybackSpeed(speed);
                    VideoControllerView.this.hide();
                }
            });
            VideoControllerView.this.popupMenu.setOnDismissListener(new PopupMenu.OnDismissListener(){

                public void onDismiss(PopupMenu menu) {
                    VideoControllerView.this.show();
                }
            });
            VideoControllerView.this.popupMenu.show();
            VideoControllerView.this.show(0);
        }
    };
    private ButtonHelper buttonHelper;
    private int progressBarColor = -1;
    private int fastForwardDuration = 15000;
    private int rewindDuration = 5000;

    public VideoControllerView(Context context) {
        super(context);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        layoutInflater.inflate(R.layout.video_controller, (ViewGroup)this, true);
        this.initControllerView();
    }

    public VideoControllerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(R.layout.video_controller, (ViewGroup)this, true);
        this.initControllerView();
        this.setupXmlAttributes(attrs);
    }

    private void setupXmlAttributes(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.VideoControllerView, 0, 0);
        this.buttonHelper.setupDrawables(typedArray);
        this.setupProgressBar(typedArray);
        typedArray.recycle();
    }

    private void setupProgressBar(TypedArray a) {
        int color = a.getColor(R.styleable.VideoControllerView_progress_color, 0);
        if (color != 0) {
            this.progressBarColor = color;
        }
        this.progress.getProgressDrawable().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
        this.progress.getThumb().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
    }

    private void initControllerView() {
        ImageButton fullscreenButton;
        if (!this.isInEditMode()) {
            this.setVisibility(4);
        }
        this.startPauseButton = (ImageButton)this.findViewById(R.id.start_pause_media_button);
        if (this.startPauseButton != null) {
            this.startPauseButton.requestFocus();
            this.startPauseButton.setOnClickListener(this.pauseListener);
        }
        if ((fullscreenButton = (ImageButton)this.findViewById(R.id.fullscreen_media_button)) != null) {
            fullscreenButton.requestFocus();
            fullscreenButton.setOnClickListener(this.fullscreenListener);
        }
        this.ffwdButton = (ImageButton)this.findViewById(R.id.forward_media_button);
        if (this.ffwdButton != null) {
            this.ffwdButton.setOnClickListener(this.ffwdListener);
        }
        this.rewButton = (ImageButton)this.findViewById(R.id.rewind_media_button);
        if (this.rewButton != null) {
            this.rewButton.setOnClickListener(this.rewListener);
        }
        this.playbackSpeedButton = (TextView)this.findViewById(R.id.playback_speed_button);
        if (this.playbackSpeedButton != null) {
            this.playbackSpeedButton.setOnClickListener(this.playbackSpeedListener);
        }
        this.buttonHelper = new ButtonHelper(this.getContext(), this.startPauseButton, this.ffwdButton, this.rewButton, fullscreenButton, this.playbackSpeedButton);
        this.progress = (SeekBar)this.findViewById(R.id.progress_seek_bar);
        if (this.progress != null) {
            this.progress.getProgressDrawable().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
            this.progress.getThumb().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
            this.progress.setOnSeekBarChangeListener(this.seekListener);
            this.progress.setMax(1000);
        }
        this.endTime = (TextView)this.findViewById(R.id.time);
        this.currentTime = (TextView)this.findViewById(R.id.time_current);
    }

    public void show() {
        this.show(3000);
    }

    private void setupButtonsVisibility() {
        if (this.videoMediaPlayer == null) {
            return;
        }
        try {
            if (this.startPauseButton != null && !this.videoMediaPlayer.canPause()) {
                this.startPauseButton.setEnabled(false);
            }
            if (this.rewButton != null && !this.videoMediaPlayer.showSeekBackwardButton()) {
                this.rewButton.setEnabled(false);
                this.rewButton.setVisibility(4);
            }
            if (this.ffwdButton != null && !this.videoMediaPlayer.showSeekForwardButton()) {
                this.ffwdButton.setEnabled(false);
                this.ffwdButton.setVisibility(4);
            }
            if (this.playbackSpeedButton != null && !this.videoMediaPlayer.showPlaybackSpeedButton()) {
                this.playbackSpeedButton.setEnabled(false);
                this.playbackSpeedButton.setVisibility(4);
            }
        }
        catch (IncompatibleClassChangeError ex) {
            ex.printStackTrace();
        }
    }

    private void show(int timeout) {
        if (!this.isShowing()) {
            this.setProgress();
            if (this.startPauseButton != null) {
                this.startPauseButton.requestFocus();
            }
            this.setupButtonsVisibility();
            this.setVisibility(0);
        }
        this.buttonHelper.updatePausePlay();
        this.buttonHelper.updateFullScreenDrawable();
        if (this.handler == null) {
            return;
        }
        this.handler.sendEmptyMessage(2);
        Message msg = this.handler.obtainMessage(1);
        if (timeout != 0) {
            this.handler.removeMessages(1);
            this.handler.sendMessageDelayed(msg, (long)timeout);
        } else {
            this.handler.removeMessages(1);
        }
    }

    public void updateFullScreenDrawable() {
        this.buttonHelper.updateFullScreenDrawable();
    }

    private boolean isShowing() {
        return this.getVisibility() == 0;
    }

    private void hide() {
        try {
            this.setVisibility(4);
            if (this.handler != null) {
                this.handler.removeMessages(2);
            }
        }
        catch (IllegalArgumentException ignored) {
            Log.w((String)"MediaController", (String)"already removed");
        }
    }

    private static CharSequence stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        return String.format(Locale.getDefault(), "%d:%02d:%02d", hours, minutes, seconds);
    }

    private int setProgress() {
        if (this.videoMediaPlayer == null || this.isDragging) {
            return 0;
        }
        int position = this.videoMediaPlayer.getCurrentPosition();
        int duration = this.videoMediaPlayer.getDuration();
        if (this.progress != null) {
            if (duration > 0) {
                long pos = 1000L * (long)position / (long)duration;
                this.progress.setProgress((int)pos);
            }
            int percent = this.videoMediaPlayer.getBufferPercentage();
            this.progress.setSecondaryProgress(percent * 10);
        }
        if (this.endTime != null) {
            this.endTime.setText(VideoControllerView.stringForTime(duration));
        }
        if (this.currentTime != null) {
            this.currentTime.setText(VideoControllerView.stringForTime(position));
        }
        return position;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        this.performClick();
        this.show(3000);
        return true;
    }

    private void doPauseResume() {
        if (this.videoMediaPlayer == null) {
            return;
        }
        this.videoMediaPlayer.onPauseResume();
        this.buttonHelper.updatePausePlay();
    }

    private void doToggleFullscreen() {
        if (this.videoMediaPlayer == null) {
            return;
        }
        this.videoMediaPlayer.toggleFullScreen();
    }

    public void setEnabled(boolean enabled) {
        if (this.startPauseButton != null) {
            this.startPauseButton.setEnabled(enabled);
        }
        if (this.ffwdButton != null) {
            this.ffwdButton.setEnabled(enabled);
        }
        if (this.rewButton != null) {
            this.rewButton.setEnabled(enabled);
        }
        if (this.playbackSpeedButton != null) {
            this.playbackSpeedButton.setEnabled(enabled);
        }
        if (this.progress != null) {
            this.progress.setEnabled(enabled);
        }
        this.setupButtonsVisibility();
        super.setEnabled(enabled);
    }

    public void onDetach() {
        this.ffwdListener = null;
        this.fullscreenListener = null;
        this.pauseListener = null;
        this.rewListener = null;
        this.seekListener = null;
        this.playbackSpeedListener = null;
        this.handler = null;
        this.videoMediaPlayer = null;
    }

    public void setEnterFullscreenDrawable(Drawable enterFullscreenDrawable) {
        this.buttonHelper.setEnterFullscreenDrawable(enterFullscreenDrawable);
    }

    public void setExitFullscreenDrawable(Drawable exitFullscreenDrawable) {
        this.buttonHelper.setExitFullscreenDrawable(exitFullscreenDrawable);
    }

    public void setProgressBarColor(int progressBarColor) {
        this.progressBarColor = ContextCompat.getColor((Context)this.getContext(), (int)progressBarColor);
    }

    public void setPlayDrawable(Drawable playDrawable) {
        this.buttonHelper.setPlayDrawable(playDrawable);
    }

    public void setPauseDrawable(Drawable pauseDrawable) {
        this.buttonHelper.setPauseDrawable(pauseDrawable);
    }

    public void setFastForwardDuration(int fastForwardDuration) {
        this.fastForwardDuration = fastForwardDuration * 1000;
    }

    public void setRewindDuration(int rewindDuration) {
        this.rewindDuration = rewindDuration * 1000;
    }

    public void setFastForwardDrawable(Drawable fastForwardDrawable) {
        this.buttonHelper.setFastForwardDrawable(fastForwardDrawable);
    }

    public void setRewindDrawable(Drawable rewindDrawable) {
        this.buttonHelper.setRewindDrawable(rewindDrawable);
    }

    public void setPlaybackSpeedOptions(PlaybackSpeedOptions playbackSpeedOptions) {
        this.popupMenu.setPlaybackSpeedOptions(playbackSpeedOptions);
    }

    public void init(final OrientationHelper orientationHelper, VideoMediaPlayer videoMediaPlayer, AttributeSet attrs) {
        this.setupXmlAttributes(attrs);
        this.videoMediaPlayer = videoMediaPlayer;
        this.buttonHelper.setOrientationHelper(orientationHelper);
        this.buttonHelper.setVideoMediaPlayer(videoMediaPlayer);
        this.buttonHelper.updatePausePlay();
        this.buttonHelper.updateFullScreenDrawable();
        this.buttonHelper.updateFastForwardDrawable();
        this.buttonHelper.updateRewindDrawable();
        this.popupMenu = new PlaybackSpeedPopupMenu(this.getContext(), (View)this.playbackSpeedButton);
        this.getViewTreeObserver().addOnWindowFocusChangeListener(new ViewTreeObserver.OnWindowFocusChangeListener(){

            public void onWindowFocusChanged(boolean hasFocus) {
                if (orientationHelper.isLandscape()) {
                    ((Activity)VideoControllerView.this.getContext()).getWindow().getDecorView().setSystemUiVisibility(5894);
                }
            }
        });
    }

    private class OnSeekChangeListener
    implements SeekBar.OnSeekBarChangeListener {
        private OnSeekChangeListener() {
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            VideoControllerView.this.show(3600000);
            VideoControllerView.this.isDragging = true;
            if (VideoControllerView.this.handler != null) {
                VideoControllerView.this.handler.removeMessages(2);
            }
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (VideoControllerView.this.videoMediaPlayer == null) {
                return;
            }
            if (!fromUser) {
                return;
            }
            long duration = VideoControllerView.this.videoMediaPlayer.getDuration();
            long newPosition = duration * (long)progress / 1000L;
            VideoControllerView.this.videoMediaPlayer.seekTo((int)newPosition);
            if (VideoControllerView.this.currentTime != null) {
                VideoControllerView.this.currentTime.setText(VideoControllerView.stringForTime((int)newPosition));
            }
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            VideoControllerView.this.isDragging = false;
            VideoControllerView.this.setProgress();
            VideoControllerView.this.buttonHelper.updatePausePlay();
            VideoControllerView.this.show(3000);
            if (VideoControllerView.this.handler != null) {
                VideoControllerView.this.handler.sendEmptyMessage(2);
            }
        }
    }

    private static class MessageHandler
    extends Handler {
        private final WeakReference<VideoControllerView> view;

        MessageHandler(VideoControllerView view) {
            this.view = new WeakReference<VideoControllerView>(view);
        }

        public void handleMessage(Message msg) {
            VideoControllerView view = (VideoControllerView)((Object)this.view.get());
            if (view == null || view.videoMediaPlayer == null) {
                return;
            }
            if (msg.what == 1) {
                view.hide();
            } else {
                int position = view.setProgress();
                if (!view.isDragging && view.isShowing() && view.videoMediaPlayer.isPlaying()) {
                    Message message = this.obtainMessage(2);
                    this.sendMessageDelayed(message, 1000 - position % 1000);
                }
            }
        }
    }
}

