/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import bg.devlabs.fullscreenvideoview.FullscreenVideoView;
import bg.devlabs.fullscreenvideoview.PlaybackSpeedOptions;
import bg.devlabs.fullscreenvideoview.VideoControllerView;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.orientation.LandscapeOrientation;
import bg.devlabs.fullscreenvideoview.orientation.OrientationHelper;
import bg.devlabs.fullscreenvideoview.orientation.PortraitOrientation;
import java.io.File;

public class Builder {
    private final FullscreenVideoView fullscreenVideoView;
    private final VideoControllerView controller;
    private final OrientationHelper orientationHelper;
    private final VideoMediaPlayer videoMediaPlayer;

    Builder(FullscreenVideoView fullscreenVideoView, VideoControllerView controller, OrientationHelper orientationHelper, VideoMediaPlayer videoMediaPlayer) {
        this.fullscreenVideoView = fullscreenVideoView;
        this.controller = controller;
        this.orientationHelper = orientationHelper;
        this.videoMediaPlayer = videoMediaPlayer;
    }

    public Builder videoFile(@NonNull File videoFile) {
        this.fullscreenVideoView.setupMediaPlayer(videoFile.getPath());
        return this;
    }

    public Builder videoUrl(@NonNull String videoUrl) {
        this.fullscreenVideoView.setupMediaPlayer(videoUrl);
        return this;
    }

    public Builder enableAutoStart() {
        this.fullscreenVideoView.enableAutoStart();
        return this;
    }

    public Builder enterFullscreenDrawable(@NonNull Drawable drawable) {
        this.controller.setEnterFullscreenDrawable(drawable);
        return this;
    }

    public Builder enterFullscreenDrawable(@DrawableRes int drawableResId) {
        this.controller.setEnterFullscreenDrawable(this.getDrawable(drawableResId));
        return this;
    }

    public Builder exitFullscreenDrawable(@NonNull Drawable drawable) {
        this.controller.setExitFullscreenDrawable(drawable);
        return this;
    }

    public Builder exitFullscreenDrawable(@DrawableRes int drawableResId) {
        this.controller.setExitFullscreenDrawable(this.getDrawable(drawableResId));
        return this;
    }

    public Builder playDrawable(@NonNull Drawable drawable) {
        this.controller.setPlayDrawable(drawable);
        return this;
    }

    public Builder playDrawable(@DrawableRes int drawableResId) {
        this.controller.setPlayDrawable(this.getDrawable(drawableResId));
        return this;
    }

    public Builder pauseDrawable(@NonNull Drawable drawable) {
        this.controller.setPauseDrawable(drawable);
        return this;
    }

    public Builder pauseDrawable(@DrawableRes int drawableResId) {
        this.controller.setPauseDrawable(this.getDrawable(drawableResId));
        return this;
    }

    public Builder fastForwardDrawable(@NonNull Drawable drawable) {
        this.controller.setFastForwardDrawable(drawable);
        return this;
    }

    public Builder fastForwardDrawable(@DrawableRes int drawableResId) {
        this.controller.setFastForwardDrawable(this.getDrawable(drawableResId));
        return this;
    }

    public Builder rewindDrawable(@NonNull Drawable drawable) {
        this.controller.setRewindDrawable(drawable);
        return this;
    }

    public Builder rewindDrawable(@DrawableRes int drawableResId) {
        this.controller.setRewindDrawable(this.getDrawable(drawableResId));
        return this;
    }

    public Builder progressBarColor(int progressBarColor) {
        this.controller.setProgressBarColor(progressBarColor);
        return this;
    }

    public Builder fastForwardSeconds(int fastForwardSeconds) {
        this.controller.setFastForwardDuration(fastForwardSeconds);
        return this;
    }

    public Builder rewindSeconds(int rewindSeconds) {
        this.controller.setRewindDuration(rewindSeconds);
        return this;
    }

    public Builder landscapeOrientation(LandscapeOrientation landscapeOrientation) {
        this.orientationHelper.setLandscapeOrientation(landscapeOrientation);
        return this;
    }

    public Builder portraitOrientation(PortraitOrientation portraitOrientation) {
        this.orientationHelper.setPortraitOrientation(portraitOrientation);
        return this;
    }

    public Builder canPause(boolean canPause) {
        this.videoMediaPlayer.setPauseEnabled(canPause);
        return this;
    }

    public Builder addSeekForwardButton() {
        this.videoMediaPlayer.addSeekForwardButton();
        return this;
    }

    public Builder addSeekBackwardButton() {
        this.videoMediaPlayer.addSeekBackwardButton();
        return this;
    }

    @RequiresApi(value=23)
    public Builder addPlaybackSpeedButton() {
        this.videoMediaPlayer.addPlaybackSpeedButton();
        return this;
    }

    @Deprecated
    public Builder canSeekBackward(boolean canSeekBackward) {
        this.videoMediaPlayer.setCanSeekBackward(canSeekBackward);
        return this;
    }

    @Deprecated
    public Builder canSeekForward(boolean canSeekForward) {
        this.videoMediaPlayer.setCanSeekForward(canSeekForward);
        return this;
    }

    private Drawable getDrawable(int drawableResId) {
        Context context = this.fullscreenVideoView.getContext();
        return ContextCompat.getDrawable((Context)context, (int)drawableResId);
    }

    public Builder playbackSpeedOptions(PlaybackSpeedOptions playbackSpeedOptions) {
        this.controller.setPlaybackSpeedOptions(playbackSpeedOptions);
        return this;
    }
}

