/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.SeekBar;
import android.widget.TextView;
import bg.devlabs.fullscreenvideoview.DrawableHelper;
import bg.devlabs.fullscreenvideoview.R;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.orientation.OrientationHelper;
import java.lang.ref.WeakReference;
import java.util.Locale;

class VideoControllerView
extends FrameLayout {
    private static final String TAG = "VideoControllerView";
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int FADE_OUT = 1;
    private static final int SHOW_PROGRESS = 2;
    @Nullable
    private VideoMediaPlayer videoMediaPlayer;
    private TextView endTime;
    private TextView currentTime;
    private boolean isDragging;
    @Nullable
    private Handler handler = new MessageHandler(this);
    private SeekBar progress;
    private ImageButton startPauseButton;
    private ImageButton ffwdButton;
    private ImageButton rewButton;
    @Nullable
    private View.OnClickListener pauseListener = new View.OnClickListener(){

        public void onClick(View v) {
            VideoControllerView.this.doPauseResume();
            VideoControllerView.this.show(3000);
        }
    };
    @Nullable
    private View.OnClickListener fullscreenListener = new View.OnClickListener(){

        public void onClick(View view) {
            VideoControllerView.this.doToggleFullscreen();
            VideoControllerView.this.show(3000);
        }
    };
    @Nullable
    private SeekBar.OnSeekBarChangeListener seekListener = new OnSeekChangeListener();
    @Nullable
    private View.OnClickListener rewListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (VideoControllerView.this.videoMediaPlayer == null) {
                return;
            }
            int pos = VideoControllerView.this.videoMediaPlayer.getCurrentPosition();
            VideoControllerView.this.videoMediaPlayer.seekTo(pos -= VideoControllerView.this.rewindDuration);
            VideoControllerView.this.setProgress();
            VideoControllerView.this.show(3000);
        }
    };
    @Nullable
    private View.OnClickListener ffwdListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (VideoControllerView.this.videoMediaPlayer == null) {
                return;
            }
            int pos = VideoControllerView.this.videoMediaPlayer.getCurrentPosition();
            VideoControllerView.this.videoMediaPlayer.seekTo(pos += VideoControllerView.this.fastForwardDuration);
            VideoControllerView.this.setProgress();
            VideoControllerView.this.show(3000);
        }
    };
    private DrawableHelper drawableHelper;
    private int progressBarColor = -1;
    private int fastForwardDuration = 15000;
    private int rewindDuration = 5000;

    public VideoControllerView(Context context) {
        super(context);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(R.layout.video_controller, (ViewGroup)this, true);
        this.initControllerView();
    }

    public VideoControllerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(R.layout.video_controller, (ViewGroup)this, true);
        this.initControllerView();
        this.setupXmlAttributes(attrs);
    }

    private void setupXmlAttributes(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.VideoControllerView, 0, 0);
        this.drawableHelper.setupDrawables(typedArray);
        this.setupProgressBar(typedArray);
        typedArray.recycle();
    }

    private void setupProgressBar(TypedArray a) {
        int color = a.getColor(R.styleable.VideoControllerView_progress_color, 0);
        if (color != 0) {
            this.progressBarColor = color;
        }
        this.progress.getProgressDrawable().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
        this.progress.getThumb().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
    }

    private void initControllerView() {
        ImageButton fullscreenButton;
        if (!this.isInEditMode()) {
            this.setVisibility(4);
        }
        this.startPauseButton = (ImageButton)this.findViewById(R.id.start_pause_media_button);
        if (this.startPauseButton != null) {
            this.startPauseButton.requestFocus();
            this.startPauseButton.setOnClickListener(this.pauseListener);
        }
        if ((fullscreenButton = (ImageButton)this.findViewById(R.id.fullscreen_media_button)) != null) {
            fullscreenButton.requestFocus();
            fullscreenButton.setOnClickListener(this.fullscreenListener);
        }
        this.ffwdButton = (ImageButton)this.findViewById(R.id.forward_media_button);
        if (this.ffwdButton != null) {
            this.ffwdButton.setOnClickListener(this.ffwdListener);
        }
        this.rewButton = (ImageButton)this.findViewById(R.id.rewind_media_button);
        if (this.rewButton != null) {
            this.rewButton.setOnClickListener(this.rewListener);
        }
        this.drawableHelper = new DrawableHelper(this.getContext(), this.startPauseButton, this.ffwdButton, this.rewButton, fullscreenButton);
        this.progress = (SeekBar)this.findViewById(R.id.progress_seek_bar);
        if (this.progress != null) {
            this.progress.getProgressDrawable().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
            this.progress.getThumb().setColorFilter(this.progressBarColor, PorterDuff.Mode.SRC_IN);
            this.progress.setOnSeekBarChangeListener(this.seekListener);
            this.progress.setMax(1000);
        }
        this.endTime = (TextView)this.findViewById(R.id.time);
        this.currentTime = (TextView)this.findViewById(R.id.time_current);
    }

    public void show() {
        this.show(3000);
    }

    private void disableUnsupportedButtons() {
        if (this.videoMediaPlayer == null) {
            return;
        }
        try {
            if (this.startPauseButton != null && !this.videoMediaPlayer.canPause()) {
                this.startPauseButton.setEnabled(false);
            }
            if (this.rewButton != null && !this.videoMediaPlayer.canSeekBackward()) {
                this.rewButton.setEnabled(false);
                this.rewButton.setVisibility(4);
            }
            if (this.ffwdButton != null && !this.videoMediaPlayer.canSeekForward()) {
                this.ffwdButton.setEnabled(false);
                this.ffwdButton.setVisibility(4);
            }
        }
        catch (IncompatibleClassChangeError ex) {
            ex.printStackTrace();
        }
    }

    private void show(int timeout) {
        if (!this.isShowing()) {
            this.setProgress();
            if (this.startPauseButton != null) {
                this.startPauseButton.requestFocus();
            }
            this.disableUnsupportedButtons();
            this.setVisibility(0);
        }
        this.drawableHelper.updatePausePlay();
        this.drawableHelper.updateFullScreenDrawable();
        if (this.handler == null) {
            return;
        }
        this.handler.sendEmptyMessage(2);
        Message msg = this.handler.obtainMessage(1);
        if (timeout != 0) {
            this.handler.removeMessages(1);
            this.handler.sendMessageDelayed(msg, (long)timeout);
        }
    }

    public void updateFullScreenDrawable() {
        this.drawableHelper.updateFullScreenDrawable();
    }

    private boolean isShowing() {
        return this.getVisibility() == 0;
    }

    private void hide() {
        try {
            this.setVisibility(4);
            if (this.handler != null) {
                this.handler.removeMessages(2);
            }
        }
        catch (IllegalArgumentException ignored) {
            Log.w((String)"MediaController", (String)"already removed");
        }
    }

    private static CharSequence stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        return String.format(Locale.getDefault(), "%d:%02d:%02d", hours, minutes, seconds);
    }

    private int setProgress() {
        if (this.videoMediaPlayer == null || this.isDragging) {
            return 0;
        }
        int position = this.videoMediaPlayer.getCurrentPosition();
        int duration = this.videoMediaPlayer.getDuration();
        if (this.progress != null) {
            if (duration > 0) {
                long pos = 1000L * (long)position / (long)duration;
                this.progress.setProgress((int)pos);
            }
            int percent = this.videoMediaPlayer.getBufferPercentage();
            this.progress.setSecondaryProgress(percent * 10);
        }
        if (this.endTime != null) {
            this.endTime.setText(VideoControllerView.stringForTime(duration));
        }
        if (this.currentTime != null) {
            this.currentTime.setText(VideoControllerView.stringForTime(position));
        }
        return position;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        this.performClick();
        this.show(3000);
        return true;
    }

    private void doPauseResume() {
        if (this.videoMediaPlayer == null) {
            return;
        }
        this.videoMediaPlayer.onPauseResume();
        this.drawableHelper.updatePausePlay();
    }

    private void doToggleFullscreen() {
        if (this.videoMediaPlayer == null) {
            return;
        }
        this.videoMediaPlayer.toggleFullScreen();
    }

    public void setEnabled(boolean enabled) {
        if (this.startPauseButton != null) {
            this.startPauseButton.setEnabled(enabled);
        }
        if (this.ffwdButton != null) {
            this.ffwdButton.setEnabled(enabled);
        }
        if (this.rewButton != null) {
            this.rewButton.setEnabled(enabled);
        }
        if (this.progress != null) {
            this.progress.setEnabled(enabled);
        }
        this.disableUnsupportedButtons();
        super.setEnabled(enabled);
    }

    public void onDetach() {
        this.ffwdListener = null;
        this.fullscreenListener = null;
        this.pauseListener = null;
        this.rewListener = null;
        this.seekListener = null;
        this.handler = null;
        this.videoMediaPlayer = null;
    }

    public void setEnterFullscreenDrawable(Drawable enterFullscreenDrawable) {
        this.drawableHelper.setEnterFullscreenDrawable(enterFullscreenDrawable);
    }

    public void setExitFullscreenDrawable(Drawable exitFullscreenDrawable) {
        this.drawableHelper.setExitFullscreenDrawable(exitFullscreenDrawable);
    }

    public void setProgressBarColor(int progressBarColor) {
        this.progressBarColor = ContextCompat.getColor((Context)this.getContext(), (int)progressBarColor);
    }

    public void setPlayDrawable(Drawable playDrawable) {
        this.drawableHelper.setPlayDrawable(playDrawable);
    }

    public void setPauseDrawable(Drawable pauseDrawable) {
        this.drawableHelper.setPauseDrawable(pauseDrawable);
    }

    public void setFastForwardDuration(int fastForwardDuration) {
        this.fastForwardDuration = fastForwardDuration * 1000;
    }

    public void setRewindDuration(int rewindDuration) {
        this.rewindDuration = rewindDuration * 1000;
    }

    public void setFastForwardDrawable(Drawable fastForwardDrawable) {
        this.drawableHelper.setFastForwardDrawable(fastForwardDrawable);
    }

    public void setRewindDrawable(Drawable rewindDrawable) {
        this.drawableHelper.setRewindDrawable(rewindDrawable);
    }

    public void init(OrientationHelper orientationHelper, VideoMediaPlayer videoMediaPlayer, AttributeSet attrs) {
        this.setupXmlAttributes(attrs);
        this.videoMediaPlayer = videoMediaPlayer;
        this.drawableHelper.setOrientationHelper(orientationHelper);
        this.drawableHelper.setVideoMediaPlayer(videoMediaPlayer);
        this.drawableHelper.updatePausePlay();
        this.drawableHelper.updateFullScreenDrawable();
        this.drawableHelper.updateFastForwardDrawable();
        this.drawableHelper.updateRewindDrawable();
    }

    private class OnSeekChangeListener
    implements SeekBar.OnSeekBarChangeListener {
        private OnSeekChangeListener() {
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            VideoControllerView.this.show(3600000);
            VideoControllerView.this.isDragging = true;
            if (VideoControllerView.this.handler != null) {
                VideoControllerView.this.handler.removeMessages(2);
            }
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (VideoControllerView.this.videoMediaPlayer == null) {
                return;
            }
            if (!fromUser) {
                return;
            }
            long duration = VideoControllerView.this.videoMediaPlayer.getDuration();
            long newPosition = duration * (long)progress / 1000L;
            VideoControllerView.this.videoMediaPlayer.seekTo((int)newPosition);
            if (VideoControllerView.this.currentTime != null) {
                VideoControllerView.this.currentTime.setText(VideoControllerView.stringForTime((int)newPosition));
            }
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            VideoControllerView.this.isDragging = false;
            VideoControllerView.this.setProgress();
            VideoControllerView.this.drawableHelper.updatePausePlay();
            VideoControllerView.this.show(3000);
            if (VideoControllerView.this.handler != null) {
                VideoControllerView.this.handler.sendEmptyMessage(2);
            }
        }
    }

    private static class MessageHandler
    extends Handler {
        private final WeakReference<VideoControllerView> view;

        MessageHandler(VideoControllerView view) {
            this.view = new WeakReference<VideoControllerView>(view);
        }

        public void handleMessage(Message msg) {
            VideoControllerView view = (VideoControllerView)((Object)this.view.get());
            if (view == null || view.videoMediaPlayer == null) {
                return;
            }
            if (msg.what == 1) {
                view.hide();
            } else {
                int position = view.setProgress();
                if (!view.isDragging && view.isShowing() && view.videoMediaPlayer.isPlaying()) {
                    Message message = this.obtainMessage(2);
                    this.sendMessageDelayed(message, 1000 - position % 1000);
                }
            }
        }
    }
}

