/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import bg.devlabs.fullscreenvideoview.FullscreenVideoView;
import bg.devlabs.fullscreenvideoview.VideoControllerView;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.orientation.LandscapeOrientation;
import bg.devlabs.fullscreenvideoview.orientation.OrientationHelper;
import bg.devlabs.fullscreenvideoview.orientation.PortraitOrientation;
import java.io.File;

public class Builder {
    private final FullscreenVideoView fullscreenVideoView;
    private final VideoControllerView controller;
    private final OrientationHelper orientationHelper;
    private final VideoMediaPlayer videoMediaPlayer;

    Builder(FullscreenVideoView fullscreenVideoView, VideoControllerView controller, OrientationHelper orientationHelper, VideoMediaPlayer videoMediaPlayer) {
        this.fullscreenVideoView = fullscreenVideoView;
        this.controller = controller;
        this.orientationHelper = orientationHelper;
        this.videoMediaPlayer = videoMediaPlayer;
    }

    Builder videoFile(@NonNull File videoFile) {
        this.fullscreenVideoView.setupMediaPlayer(videoFile.getPath());
        return this;
    }

    Builder videoUrl(@NonNull String videoUrl) {
        this.fullscreenVideoView.setupMediaPlayer(videoUrl);
        return this;
    }

    public Builder enableAutoStart() {
        this.fullscreenVideoView.enableAutoStart();
        return this;
    }

    public Builder enterFullscreenDrawable(@NonNull Drawable enterFullscreenDrawable) {
        this.controller.setEnterFullscreenDrawable(enterFullscreenDrawable);
        return this;
    }

    public Builder enterFullscreenDrawable(@DrawableRes int enterFullscreenDrawableResId) {
        this.controller.setEnterFullscreenDrawable(this.getDrawable(enterFullscreenDrawableResId));
        return this;
    }

    public Builder exitFullscreenDrawable(@NonNull Drawable exitFullscreenDrawable) {
        this.controller.setExitFullscreenDrawable(exitFullscreenDrawable);
        return this;
    }

    public Builder exitFullscreenDrawable(@DrawableRes int exitFullscreenDrawable) {
        this.controller.setExitFullscreenDrawable(this.getDrawable(exitFullscreenDrawable));
        return this;
    }

    public Builder playDrawable(@NonNull Drawable playDrawable) {
        this.controller.setPlayDrawable(playDrawable);
        return this;
    }

    public Builder playDrawable(@DrawableRes int playDrawable) {
        this.controller.setPlayDrawable(this.getDrawable(playDrawable));
        return this;
    }

    public Builder pauseDrawable(@NonNull Drawable pauseDrawable) {
        this.controller.setPauseDrawable(pauseDrawable);
        return this;
    }

    public Builder pauseDrawable(@DrawableRes int pauseDrawable) {
        this.controller.setPauseDrawable(this.getDrawable(pauseDrawable));
        return this;
    }

    public Builder fastForwardDrawable(@NonNull Drawable fastForwardDrawable) {
        this.controller.setFastForwardDrawable(fastForwardDrawable);
        return this;
    }

    public Builder fastForwardDrawable(@DrawableRes int fastForwardDrawable) {
        this.controller.setFastForwardDrawable(this.getDrawable(fastForwardDrawable));
        return this;
    }

    public Builder rewindDrawable(@NonNull Drawable rewindDrawable) {
        this.controller.setRewindDrawable(rewindDrawable);
        return this;
    }

    public Builder rewindDrawable(@DrawableRes int rewindDrawable) {
        this.controller.setRewindDrawable(this.getDrawable(rewindDrawable));
        return this;
    }

    public Builder progressBarColor(int progressBarColor) {
        this.controller.setProgressBarColor(progressBarColor);
        return this;
    }

    public Builder fastForwardSeconds(int fastForwardSeconds) {
        this.controller.setFastForwardDuration(fastForwardSeconds);
        return this;
    }

    public Builder rewindSeconds(int rewindSeconds) {
        this.controller.setRewindDuration(rewindSeconds);
        return this;
    }

    public Builder landscapeOrientation(LandscapeOrientation landscapeOrientation) {
        this.orientationHelper.setLandscapeOrientation(landscapeOrientation);
        return this;
    }

    public Builder portraitOrientation(PortraitOrientation portraitOrientation) {
        this.orientationHelper.setPortraitOrientation(portraitOrientation);
        return this;
    }

    public Builder canPause(boolean canPause) {
        this.videoMediaPlayer.setPauseEnabled(canPause);
        return this;
    }

    public Builder canSeekBackward(boolean canSeekBackward) {
        this.videoMediaPlayer.setCanSeekBackward(canSeekBackward);
        return this;
    }

    public Builder canSeekForward(boolean canSeekForward) {
        this.videoMediaPlayer.setCanSeekForward(canSeekForward);
        return this;
    }

    private Drawable getDrawable(int drawableResId) {
        Context context = this.fullscreenVideoView.getContext();
        return ContextCompat.getDrawable((Context)context, (int)drawableResId);
    }
}

