/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toolbar;
import bg.devlabs.fullscreenvideoview.FullscreenVideoView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UiUtils {
    private UiUtils() {
    }

    public static void showOtherViews(ViewGroup parentLayout) {
        List<View> views = UiUtils.getAllChildViews((View)parentLayout);
        int size = views.size();
        for (int i = 0; i < size; ++i) {
            View view = views.get(i);
            view.setVisibility(0);
        }
    }

    public static void hideOtherViews(ViewGroup parentLayout) {
        List<View> views = UiUtils.getAllChildViews((View)parentLayout);
        int size = views.size();
        for (int i = 0; i < size; ++i) {
            View view = views.get(i);
            view.setVisibility(8);
        }
    }

    private static List<View> getAllChildViews(View parentLayout) {
        if (!UiUtils.shouldCheckChildren(parentLayout)) {
            return Collections.singletonList(parentLayout);
        }
        int childCount = ((ViewGroup)parentLayout).getChildCount();
        ArrayList<View> children = new ArrayList<View>(childCount);
        for (int i = 0; i < childCount; ++i) {
            View view = ((ViewGroup)parentLayout).getChildAt(i);
            if (UiUtils.shouldCheckChildren(view)) {
                children.addAll(UiUtils.getAllChildViews(view));
                continue;
            }
            if (view instanceof FullscreenVideoView) continue;
            children.add(view);
        }
        return children;
    }

    private static boolean shouldCheckChildren(View view) {
        if (Build.VERSION.SDK_INT >= 21) {
            return view instanceof ViewGroup && !(view instanceof android.support.v7.widget.Toolbar) && !(view instanceof Toolbar) && !(view instanceof FullscreenVideoView);
        }
        return view instanceof ViewGroup && !(view instanceof android.support.v7.widget.Toolbar) && !(view instanceof FullscreenVideoView);
    }
}

