/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview;

import android.content.Context;
import android.content.res.Configuration;
import android.media.AudioAttributes;
import android.media.MediaPlayer;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import bg.devlabs.fullscreenvideoview.Builder;
import bg.devlabs.fullscreenvideoview.R;
import bg.devlabs.fullscreenvideoview.VideoControllerView;
import bg.devlabs.fullscreenvideoview.VideoMediaPlayer;
import bg.devlabs.fullscreenvideoview.VideoSurfaceView;
import bg.devlabs.fullscreenvideoview.orientation.OrientationHelper;
import java.io.File;
import java.io.IOException;

public class FullscreenVideoView
extends FrameLayout {
    @Nullable
    VideoSurfaceView surfaceView;
    @Nullable
    SurfaceHolder surfaceHolder;
    @Nullable
    private ProgressBar progressBar;
    @Nullable
    VideoControllerView controller;
    @Nullable
    VideoMediaPlayer videoMediaPlayer;
    boolean isMediaPlayerPrepared;
    @Nullable
    OrientationHelper orientationHelper;
    private SurfaceHolder.Callback surfaceHolderCallback;
    boolean isPaused;

    public FullscreenVideoView(@NonNull Context context) {
        super(context);
    }

    public FullscreenVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public FullscreenVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.findChildViews();
        if (!this.isInEditMode()) {
            this.videoMediaPlayer = new VideoMediaPlayer(this);
            this.orientationHelper = new OrientationHelper(this.getContext(), this);
            this.orientationHelper.enable();
        }
        this.setupSurfaceHolder();
        if (this.controller != null) {
            this.controller.init(this.orientationHelper, this.videoMediaPlayer, attrs);
        }
        this.setupProgressBarColor();
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.initOnBackPressedListener();
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                view.performClick();
                if (FullscreenVideoView.this.controller != null) {
                    FullscreenVideoView.this.controller.show();
                }
                return false;
            }
        });
    }

    private void setupSurfaceHolder() {
        if (this.surfaceView != null) {
            this.surfaceHolderCallback = new SurfaceHolder.Callback(){

                public void surfaceCreated(SurfaceHolder holder) {
                    if (FullscreenVideoView.this.videoMediaPlayer != null) {
                        FullscreenVideoView.this.videoMediaPlayer.setDisplay(FullscreenVideoView.this.surfaceHolder);
                    }
                }

                public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                }

                public void surfaceDestroyed(SurfaceHolder holder) {
                    if (FullscreenVideoView.this.videoMediaPlayer != null && FullscreenVideoView.this.isMediaPlayerPrepared) {
                        FullscreenVideoView.this.videoMediaPlayer.pause();
                    }
                }
            };
            this.surfaceHolder = this.surfaceView.getHolder();
            this.surfaceHolder.addCallback(this.surfaceHolderCallback);
        }
    }

    private void findChildViews() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(R.layout.fullscreen_video_view, (ViewGroup)this, true);
        this.surfaceView = (VideoSurfaceView)this.findViewById(R.id.surface_view);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.controller = (VideoControllerView)this.findViewById(R.id.video_controller);
    }

    private void initOnBackPressedListener() {
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                return event.getAction() == 1 && keyCode == 4 && FullscreenVideoView.this.orientationHelper.shouldHandleOnBackPressed();
            }
        });
    }

    public Builder videoFile(File videoFile) {
        return new Builder(this, this.controller, this.orientationHelper, this.videoMediaPlayer).videoFile(videoFile);
    }

    public Builder videoUrl(String videoUrl) {
        return new Builder(this, this.controller, this.orientationHelper, this.videoMediaPlayer).videoUrl(videoUrl);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == 2) {
            if (this.orientationHelper != null) {
                this.orientationHelper.activateFullscreen();
            }
        } else if (newConfig.orientation == 1 && this.orientationHelper != null) {
            this.orientationHelper.exitFullscreen();
        }
    }

    protected void onDetachedFromWindow() {
        this.handleOnDetach();
        super.onDetachedFromWindow();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.isPaused = visibility != 0;
    }

    private void handleOnDetach() {
        if (this.controller != null) {
            this.controller.onDetach();
        }
        if (this.orientationHelper != null) {
            this.orientationHelper.disable();
        }
        if (this.videoMediaPlayer != null) {
            this.videoMediaPlayer.onDetach();
        }
        if (this.surfaceHolder != null) {
            this.surfaceHolder.removeCallback(this.surfaceHolderCallback);
            this.surfaceHolder.getSurface().release();
        }
        if (this.surfaceView != null) {
            this.surfaceView.invalidate();
            this.surfaceView.destroyDrawingCache();
        }
        this.controller = null;
        this.orientationHelper = null;
        this.videoMediaPlayer = null;
        this.surfaceHolder = null;
        this.surfaceView = null;
        this.progressBar = null;
        this.setOnKeyListener(null);
        this.setOnTouchListener(null);
    }

    void setupMediaPlayer(String videoPath) {
        this.showProgress();
        try {
            if (this.videoMediaPlayer != null) {
                if (Build.VERSION.SDK_INT >= 21) {
                    AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(1).setLegacyStreamType(3).build();
                    this.videoMediaPlayer.setAudioAttributes(audioAttributes);
                } else {
                    this.videoMediaPlayer.setAudioStreamType(3);
                }
                this.videoMediaPlayer.setDataSource(videoPath);
                this.videoMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    public void onPrepared(MediaPlayer mediaPlayer) {
                        FullscreenVideoView.this.hideProgress();
                        int videoWidth = FullscreenVideoView.this.videoMediaPlayer.getVideoWidth();
                        int videoHeight = FullscreenVideoView.this.videoMediaPlayer.getVideoHeight();
                        if (FullscreenVideoView.this.surfaceView != null) {
                            FullscreenVideoView.this.surfaceView.updateLayoutParams(videoWidth, videoHeight);
                        }
                        if (!FullscreenVideoView.this.isPaused) {
                            FullscreenVideoView.this.isMediaPlayerPrepared = true;
                            if (mediaPlayer != null && FullscreenVideoView.this.videoMediaPlayer.isAutoStartEnabled()) {
                                mediaPlayer.start();
                            }
                        }
                    }
                });
                this.videoMediaPlayer.prepareAsync();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setupProgressBarColor() {
        int shortAnimTime = this.getResources().getInteger(0x10E0000);
        if (this.progressBar != null) {
            this.progressBar.animate().setDuration((long)shortAnimTime);
        }
    }

    void hideProgress() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(4);
        }
    }

    private void showProgress() {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(0);
        }
    }

    void toggleFullscreen() {
        if (this.orientationHelper != null) {
            this.orientationHelper.toggleFullscreen();
        }
    }

    void enableAutoStart() {
        if (this.videoMediaPlayer != null) {
            this.videoMediaPlayer.enableAutoStart();
        }
    }

    public void onOrientationChanged() {
        if (this.controller != null) {
            this.controller.updateFullScreenDrawable();
        }
        if (this.surfaceView != null) {
            if (this.orientationHelper.isLandscape()) {
                this.surfaceView.resetLayoutParams();
            } else {
                this.surfaceView.updateLayoutParams(this.videoMediaPlayer.getVideoWidth(), this.videoMediaPlayer.getVideoHeight());
            }
        }
    }
}

