/*
 * Decompiled with CFR 0.152.
 */
package bg.devlabs.fullscreenvideoview.orientation;

import android.app.ActionBar;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.support.v7.app.AppCompatActivity;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import bg.devlabs.fullscreenvideoview.FullscreenVideoView;
import bg.devlabs.fullscreenvideoview.UiUtils;
import bg.devlabs.fullscreenvideoview.orientation.LandscapeOrientation;
import bg.devlabs.fullscreenvideoview.orientation.PortraitOrientation;

public class OrientationHelper
extends OrientationEventListener {
    private static final int LEFT_LANDSCAPE = 90;
    private static final int RIGHT_LANDSCAPE = 270;
    private static final int PORTRAIT = 0;
    private static final int ROTATE_THRESHOLD = 10;
    private final FullscreenVideoView videoView;
    private int originalWidth;
    private int originalHeight;
    private boolean isLandscape;
    private final ContentResolver contentResolver;
    private LandscapeOrientation landscapeOrientation = LandscapeOrientation.SENSOR;
    private PortraitOrientation portraitOrientation = PortraitOrientation.DEFAULT;
    private boolean shouldEnterPortrait;

    public OrientationHelper(Context context, FullscreenVideoView fullscreenVideoView) {
        super(context);
        this.videoView = fullscreenVideoView;
        this.contentResolver = context.getContentResolver();
    }

    public void activateFullscreen() {
        if (!this.isLandscape) {
            this.isLandscape = true;
        }
        this.videoView.onOrientationChanged();
        Activity activity = (Activity)this.videoView.getContext();
        this.setOrientation(this.landscapeOrientation.getValue());
        UiUtils.hideOtherViews(this.getParent());
        this.originalWidth = this.videoView.getWidth();
        this.originalHeight = this.videoView.getHeight();
        this.updateLayoutParams();
        this.toggleActionBarVisibility(false);
        OrientationHelper.toggleSystemUiVisibility(activity.getWindow());
    }

    private void updateLayoutParams() {
        ViewGroup.LayoutParams params = this.videoView.getLayoutParams();
        Context context = this.videoView.getContext();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager == null) {
            return;
        }
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics realMetrics = new DisplayMetrics();
        display.getRealMetrics(realMetrics);
        params.width = realMetrics.widthPixels;
        params.height = realMetrics.heightPixels;
        this.videoView.setLayoutParams(params);
    }

    public void exitFullscreen() {
        if (this.isLandscape) {
            this.isLandscape = false;
        }
        this.videoView.onOrientationChanged();
        Activity activity = (Activity)this.videoView.getContext();
        this.setOrientation(this.portraitOrientation.getValue());
        UiUtils.showOtherViews(this.getParent());
        ViewGroup.LayoutParams params = this.videoView.getLayoutParams();
        params.width = this.originalWidth;
        params.height = this.originalHeight;
        this.videoView.setLayoutParams(params);
        this.toggleActionBarVisibility(true);
        OrientationHelper.toggleSystemUiVisibility(activity.getWindow());
    }

    private ViewGroup getParent() {
        Window window = ((Activity)this.videoView.getContext()).getWindow();
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        return (ViewGroup)decorView.findViewById(0x1020002);
    }

    private static void toggleSystemUiVisibility(Window activityWindow) {
        int newUiOptions = activityWindow.getDecorView().getSystemUiVisibility();
        newUiOptions ^= 2;
        newUiOptions ^= 4;
        activityWindow.getDecorView().setSystemUiVisibility(newUiOptions ^= 0x1000);
    }

    private void toggleActionBarVisibility(boolean visible) {
        android.support.v7.app.ActionBar supportActionBar = ((AppCompatActivity)this.videoView.getContext()).getSupportActionBar();
        ActionBar actionBar = ((Activity)this.videoView.getContext()).getActionBar();
        if (visible) {
            if (supportActionBar != null) {
                supportActionBar.show();
            }
            if (actionBar != null) {
                actionBar.show();
            }
        } else {
            if (supportActionBar != null) {
                supportActionBar.hide();
            }
            if (actionBar != null) {
                actionBar.hide();
            }
        }
    }

    private void setOrientation(int orientation) {
        ((Activity)this.videoView.getContext()).setRequestedOrientation(orientation);
    }

    public boolean shouldHandleOnBackPressed() {
        if (this.isLandscape) {
            this.setOrientation(this.portraitOrientation.getValue());
            this.videoView.onOrientationChanged();
            return true;
        }
        return false;
    }

    public void toggleFullscreen() {
        this.isLandscape = !this.isLandscape;
        int newOrientation = this.portraitOrientation.getValue();
        if (this.isLandscape) {
            newOrientation = this.landscapeOrientation.getValue();
        }
        this.setOrientation(newOrientation);
    }

    public void setLandscapeOrientation(LandscapeOrientation landscapeOrientation) {
        this.landscapeOrientation = landscapeOrientation;
    }

    public void setPortraitOrientation(PortraitOrientation portraitOrientation) {
        this.portraitOrientation = portraitOrientation;
    }

    private static boolean shouldChangeOrientation(int a, int b) {
        return a > b - 10 && a < b + 10;
    }

    public void onOrientationChanged(int orientation) {
        if (!OrientationHelper.isRotationEnabled(this.contentResolver)) {
            return;
        }
        if ((OrientationHelper.shouldChangeOrientation(orientation, 90) || OrientationHelper.shouldChangeOrientation(orientation, 270)) && !this.shouldEnterPortrait) {
            this.shouldEnterPortrait = true;
            this.setOrientation(6);
        }
        if (OrientationHelper.shouldChangeOrientation(orientation, 0) && this.shouldEnterPortrait) {
            this.shouldEnterPortrait = false;
            this.setOrientation(1);
        }
    }

    private static boolean isRotationEnabled(ContentResolver contentResolver) {
        return Settings.System.getInt((ContentResolver)contentResolver, (String)"accelerometer_rotation", (int)0) == 1;
    }

    public boolean isLandscape() {
        return this.isLandscape;
    }
}

