/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.db;

import android.content.ContentValues;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import bg.dalexiev.bender.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class SqlInsertionBuilder {
    private static final String CONFLICT_NONE = "";
    private static final String CONFLICT_ROLLBACK = "or rollback ";
    private static final String CONFLICT_ABORT = "or abort ";
    private static final String CONFLICT_FAIL = "or fail ";
    private static final String CONFLICT_IGNORE = "or ignore ";
    private static final String CONFLICT_REPLACE = "or replace ";
    private String mTable;
    private List<ContentValues> mContentValues;

    @NonNull
    public SqlInsertionBuilder setTable(@NonNull String table) {
        Preconditions.argumentNotNull(table, "Table can't be null");
        this.mTable = table;
        return this;
    }

    @NonNull
    public SqlInsertionBuilder appendValues(ContentValues ... values) {
        Preconditions.argumentNotNull(values, "Values can't be null");
        Preconditions.argumentCondition(values.length == 0, "Values can't be empty");
        if (this.mContentValues == null) {
            this.mContentValues = new ArrayList<ContentValues>();
        }
        Collections.addAll(this.mContentValues, values);
        return this;
    }

    public List<Long> insert(@NonNull SQLiteDatabase db) {
        return this.insert(db, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> insert(@NonNull SQLiteDatabase db, int onConflict) {
        Preconditions.argumentNotNull(db, "Database can't be null");
        Preconditions.stateNotNull(this.mTable, "Can't execute an insert with no table set. Did you call setTable()?");
        String sql = this.generateSql(onConflict);
        LinkedList<Long> generatedIds = new LinkedList<Long>();
        try (SQLiteStatement statement = db.compileStatement(sql);){
            this.executeInsertStatement(statement, generatedIds);
        }
        return generatedIds;
    }

    private void executeInsertStatement(SQLiteStatement statement, List<Long> generatedIds) {
        for (ContentValues values : this.mContentValues) {
            statement.clearBindings();
            SqlInsertionBuilder.bindValues(statement, values);
            generatedIds.add(statement.executeInsert());
        }
    }

    @VisibleForTesting
    String generateSql(int onConflict) {
        Set<String> columnNames = SqlInsertionBuilder.getColumnNames(this.mContentValues.get(0));
        return new StringBuilder(152).append("insert ").append(SqlInsertionBuilder.getConflictClause(onConflict)).append("into ").append(this.mTable).append('(').append(SqlInsertionBuilder.generateColumns(columnNames)).append(") values (").append(SqlInsertionBuilder.generateValues(columnNames.size())).append(')').toString();
    }

    private static String getConflictClause(int onConflict) {
        switch (onConflict) {
            case 2: {
                return CONFLICT_ABORT;
            }
            case 3: {
                return CONFLICT_FAIL;
            }
            case 4: {
                return CONFLICT_IGNORE;
            }
            case 5: {
                return CONFLICT_REPLACE;
            }
            case 1: {
                return CONFLICT_ROLLBACK;
            }
        }
        return CONFLICT_NONE;
    }

    private static String generateColumns(Set<String> columnNames) {
        StringBuilder columnBuilder = new StringBuilder();
        for (String columnName : columnNames) {
            columnBuilder.append(columnName);
            columnBuilder.append(", ");
        }
        return columnBuilder.substring(0, columnBuilder.length() - 2);
    }

    private static Set<String> getColumnNames(ContentValues contentValues) {
        Set columnNames = contentValues == null ? Collections.singleton("_id") : contentValues.keySet();
        return columnNames;
    }

    private static String generateValues(int size) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            valueBuilder.append("?, ");
        }
        return valueBuilder.substring(0, valueBuilder.length() - 2);
    }

    private static void bindValues(SQLiteStatement statement, ContentValues contentValues) {
        if (contentValues == null) {
            return;
        }
        int parameterIndex = 1;
        for (String column : contentValues.keySet()) {
            String value = contentValues.getAsString(column);
            if (value == null) {
                statement.bindNull(parameterIndex);
            } else {
                statement.bindString(parameterIndex, value);
            }
            ++parameterIndex;
        }
    }
}

