/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.content.Context;
import android.content.Loader;
import android.database.ContentObserver;
import android.os.Build;
import android.support.annotation.NonNull;
import bg.dalexiev.bender.content.EntityCursor;
import bg.dalexiev.bender.content.QueryCommand;
import bg.dalexiev.bender.util.Preconditions;

public class EntityCursorLoader<E>
extends Loader<EntityCursor<E>>
implements QueryCommand.Callback<E> {
    private final QueryCommand<E> mQueryCommand;
    private final ContentObserver mObserver;
    private final int mToken;
    private EntityCursor<E> mCursor;
    private boolean mIsLoadComplete;
    private boolean mIsCancelled;

    EntityCursorLoader(Context context, @NonNull QueryCommand<E> queryCommand, int token) {
        super(context);
        Preconditions.argumentNotNull(queryCommand, "Query command is required");
        this.mQueryCommand = queryCommand;
        this.mObserver = new Loader.ForceLoadContentObserver((Loader)this);
        this.mToken = token;
    }

    protected void onStartLoading() {
        this.mIsCancelled = false;
        this.mIsLoadComplete = false;
        if (this.mCursor != null) {
            this.deliverResult(this.mCursor);
            return;
        }
        if (this.takeContentChanged() || this.mCursor == null) {
            this.forceLoad();
        }
    }

    protected void onForceLoad() {
        this.mIsCancelled = false;
        this.mQueryCommand.executeAsync(this.mToken, this);
    }

    protected void onStopLoading() {
        this.onCancelLoad();
    }

    protected void onReset() {
        this.mIsCancelled = false;
        this.mIsLoadComplete = false;
        this.onStopLoading();
        if (this.mCursor != null && !this.mCursor.isClosed()) {
            this.mCursor.close();
            this.mCursor = null;
        }
    }

    protected boolean onCancelLoad() {
        this.mIsCancelled = true;
        this.mQueryCommand.cancel();
        return !this.mIsLoadComplete;
    }

    public void deliverResult(EntityCursor<E> data) {
        if (this.isReset()) {
            this.closeCursor(data);
        }
        EntityCursor<E> oldCursor = this.mCursor;
        this.mCursor = data;
        if (this.isStarted()) {
            super.deliverResult(this.mCursor);
        }
        if (oldCursor != null && !oldCursor.isClosed()) {
            oldCursor.close();
        }
    }

    @Override
    public void onQueryComplete(int token, EntityCursor<E> cursor) {
        if (token == this.mToken) {
            this.mIsLoadComplete = true;
            if (this.mIsCancelled) {
                this.dispatchCancelled(cursor);
            } else {
                this.dispatchResult(cursor);
            }
        }
    }

    private void dispatchResult(EntityCursor<E> cursor) {
        if (this.isAbandoned()) {
            this.closeCursor(cursor);
            return;
        }
        cursor.registerContentObserver(this.mObserver);
        if (Build.VERSION.SDK_INT >= 18) {
            this.commitContentChanged();
        }
        this.deliverResult(cursor);
    }

    private void dispatchCancelled(EntityCursor<E> cursor) {
        this.closeCursor(cursor);
        if (Build.VERSION.SDK_INT >= 18) {
            this.rollbackContentChanged();
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.deliverCancellation();
        }
    }

    private void closeCursor(EntityCursor<E> cursor) {
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
    }
}

