/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWrapper;
import android.util.SparseArray;
import bg.dalexiev.bender.content.DefaultCursorMapper;
import bg.dalexiev.bender.mapper.CursorMapper;
import bg.dalexiev.bender.mapper.RowMapper;

public class EntityCursor<E>
extends CursorWrapper {
    private final CursorMapper<E> mCursorMapper;
    private SparseArray<E> mCache;
    private int mPosition;

    EntityCursor(Cursor cursor, CursorMapper<E> cursorMapper) {
        super(cursor);
        this.mCursorMapper = cursorMapper;
        this.mPosition = -1;
    }

    EntityCursor(Cursor cursor, RowMapper<E> rowMapper) {
        this(cursor, new DefaultCursorMapper<E>(rowMapper));
    }

    final void mapCursor() {
        Cursor cursor = this.getWrappedCursor();
        if (cursor == null || cursor.getCount() == 0) {
            return;
        }
        this.mCache = this.mCursorMapper.mapCursor(cursor);
        cursor.moveToFirst();
    }

    public E getEntity() {
        if (0 > this.mPosition || this.mPosition >= this.getCount()) {
            throw new CursorIndexOutOfBoundsException("Invalid cursor position: " + this.mPosition);
        }
        return (E)this.mCache.get(this.mPosition);
    }

    public int getCount() {
        if (this.mCache == null) {
            return 0;
        }
        return this.mCache.size();
    }

    public int getPosition() {
        return this.mPosition;
    }

    public boolean moveToPosition(int position) {
        if (position >= this.getCount()) {
            this.mPosition = this.getCount();
            return false;
        }
        if (position < 0) {
            this.mPosition = -1;
            return false;
        }
        if (position == this.mPosition) {
            return true;
        }
        this.mPosition = position;
        return true;
    }

    public boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    public boolean moveToLast() {
        return this.moveToPosition(this.getCount() - 1);
    }

    public boolean moveToNext() {
        return this.moveToPosition(this.mPosition + 1);
    }

    public boolean moveToPrevious() {
        return this.moveToPosition(this.mPosition - 1);
    }

    public boolean move(int offset) {
        int newPosition = this.mPosition + offset;
        this.mPosition = offset < 0 ? Math.max(-1, newPosition) : Math.min(this.getCount(), newPosition);
        return this.mPosition == newPosition;
    }

    public boolean isBeforeFirst() {
        return -1 == this.mPosition;
    }

    public boolean isAfterLast() {
        return this.getCount() == this.mPosition;
    }

    public boolean isFirst() {
        return 0 == this.mPosition;
    }

    public boolean isLast() {
        return this.getCount() - 1 == this.mPosition;
    }

    public void close() {
        super.close();
        if (this.mCache != null) {
            this.mCache.clear();
        }
    }
}

