/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.content.ContentResolver;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import bg.dalexiev.bender.content.BaseResolverCommand;
import bg.dalexiev.bender.db.Predicate;
import bg.dalexiev.bender.db.SqlSelectionBuilder;
import bg.dalexiev.bender.util.Preconditions;

public class DeleteCommand
extends BaseResolverCommand<Integer, Callback, DeleteCommand> {
    private final SqlSelectionBuilder mSelectionBuilder;

    DeleteCommand(ContentResolver contentResolver) {
        super(contentResolver);
        this.mSelectionBuilder = new SqlSelectionBuilder();
    }

    @VisibleForTesting
    DeleteCommand(BaseResolverCommand.WorkerHandler workerHandler, ContentResolver contentResolver, SqlSelectionBuilder selectionBuilder) {
        super(workerHandler, contentResolver);
        this.mSelectionBuilder = selectionBuilder;
    }

    @NonNull
    public DeleteCommand where(@NonNull String selection, String ... selectionArgs) {
        Preconditions.argumentNotNull(selection, "Selection can't be null");
        this.mSelectionBuilder.where(selection, selectionArgs);
        return this;
    }

    public DeleteCommand where(@NonNull Predicate predicate) {
        this.mSelectionBuilder.where(predicate);
        return this;
    }

    public DeleteCommand orWhere(@NonNull String selection, String ... selectionArgs) {
        Preconditions.argumentNotNull(selection, "Selection can't be null");
        this.mSelectionBuilder.orWhere(selection, selectionArgs);
        return this;
    }

    public DeleteCommand orWhere(@NonNull Predicate predicate) {
        this.mSelectionBuilder.orWhere(predicate);
        return this;
    }

    @Override
    protected Integer executeResolverCommand(@NonNull ContentResolver contentResolver) {
        Uri uri = this.getUri();
        return contentResolver.delete(uri, this.mSelectionBuilder.getSelection(), this.mSelectionBuilder.getSelectionArgs());
    }

    @Override
    protected void notifyCallback(@NonNull Callback callback, int token, Integer result) {
        callback.onDeleteComplete(token, result);
    }

    public static interface Callback
    extends BaseResolverCommand.Callback {
        public void onDeleteComplete(int var1, int var2);
    }
}

