/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.content.UriMatcher;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import bg.dalexiev.bender.util.Preconditions;

public class DatabaseUriMatcher {
    public static final int TYPE_TABLE = 0;
    public static final int TYPE_ROW = 1;
    private final UriMatcher mUriMatcher;

    public DatabaseUriMatcher(@NonNull String authority) {
        Preconditions.argumentNotNull(authority, "Authority can't be null;");
        this.mUriMatcher = new UriMatcher(-1);
        this.mUriMatcher.addURI(authority, "*", 0);
        this.mUriMatcher.addURI(authority, "*/#", 1);
    }

    @Nullable
    public Result match(@NonNull Uri uri) {
        switch (this.mUriMatcher.match(uri)) {
            case 0: {
                return new Result(0, uri.getLastPathSegment(), false, null);
            }
            case 1: {
                return new Result(1, (String)uri.getPathSegments().get(0), true, uri.getLastPathSegment());
            }
        }
        return null;
    }

    public static final class Result {
        public final int code;
        public final String table;
        public final boolean isRow;
        public final String id;

        public Result(int code, @NonNull String table, boolean isRow, @Nullable String id) {
            this.code = code;
            this.table = table;
            this.isRow = isRow;
            this.id = id;
        }
    }
}

