/*
 * Decompiled with CFR 0.152.
 */
package bg.dalexiev.bender.content;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import bg.dalexiev.bender.content.DatabaseUriMatcher;
import bg.dalexiev.bender.db.Predicate;
import bg.dalexiev.bender.db.SqlInsertionBuilder;
import bg.dalexiev.bender.db.SqlSelectionBuilder;
import bg.dalexiev.bender.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

public abstract class DatabaseContentProvider
extends ContentProvider {
    public static final String PARAM_CONFLICT_ALGORITHM = "onConflict";
    private String mAuthority;
    private SQLiteOpenHelper mHelper;
    private DatabaseUriMatcher mUriMatcher;

    @CallSuper
    public boolean onCreate() {
        this.mAuthority = this.createAuthority();
        Preconditions.stateNotNull(this.mAuthority, "Authority can't be null. Check your createAuthority() implementation.");
        this.mHelper = this.createHelper(this.getContext());
        Preconditions.stateNotNull(this.mHelper, "Database helper can't be null, Check your createHelper() implementation");
        this.mUriMatcher = this.createUriMatcher(this.mAuthority);
        Preconditions.stateNotNull(this.mUriMatcher, "Uri matcher can't be null. Check your createUriMatcher() implementation");
        return true;
    }

    @NonNull
    protected abstract String createAuthority();

    @NonNull
    protected abstract SQLiteOpenHelper createHelper(@Nullable Context var1);

    @NonNull
    protected DatabaseUriMatcher createUriMatcher(@NonNull String authority) {
        return new DatabaseUriMatcher(authority);
    }

    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Preconditions.argumentNotNull(uri, "Uri can't be null");
        DatabaseUriMatcher.Result match = this.matchUri(uri);
        SQLiteDatabase db = this.mHelper.getWritableDatabase();
        SqlSelectionBuilder builder = this.buildQuerySelection(uri, match, selection, selectionArgs, sortOrder);
        Cursor cursor = builder.query(db, projection);
        Context context = this.getContext();
        if (cursor != null && context != null) {
            cursor.setNotificationUri(context.getContentResolver(), uri);
        }
        return cursor;
    }

    @NonNull
    private DatabaseUriMatcher.Result matchUri(@NonNull Uri uri) {
        DatabaseUriMatcher.Result match = this.mUriMatcher.match(uri);
        if (match == null) {
            throw new UnsupportedOperationException("Unsupported content uri: " + uri);
        }
        return match;
    }

    @NonNull
    protected SqlSelectionBuilder buildQuerySelection(@NonNull Uri uri, @NonNull DatabaseUriMatcher.Result match, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        SqlSelectionBuilder builder = new SqlSelectionBuilder();
        switch (match.code) {
            case 1: {
                builder.where(Predicate.eq("_id", match.id));
            }
            case 0: {
                return builder.setTable(match.table).where(selection, selectionArgs).orderBy(sortOrder);
            }
        }
        return builder;
    }

    public String getType(@NonNull Uri uri) {
        Preconditions.argumentNotNull(uri, "Uri can't be null");
        StringBuilder typeBuilder = new StringBuilder();
        DatabaseUriMatcher.Result match = this.matchUri(uri);
        switch (match.code) {
            case 0: {
                typeBuilder.append("vnd.android.cursor.dir");
                break;
            }
            case 1: {
                typeBuilder.append("vnd.android.cursor.item");
            }
        }
        typeBuilder.append("/vnd.").append(this.mAuthority).append('.').append((String)uri.getPathSegments().get(0));
        return typeBuilder.toString();
    }

    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        Preconditions.argumentNotNull(uri, "Uri can't be null");
        DatabaseUriMatcher.Result match = this.matchInsertUri(uri);
        SQLiteDatabase db = this.mHelper.getWritableDatabase();
        SqlInsertionBuilder builder = this.buildInsertion(uri, match, values);
        int conflictAlgorithm = DatabaseContentProvider.getConflictAlgorithm(uri);
        List<Long> generatedIds = builder.insert(db, conflictAlgorithm);
        this.notifyChange(uri);
        return ContentUris.withAppendedId((Uri)uri, (long)generatedIds.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(@NonNull Uri uri, @Nullable ContentValues[] values) {
        Preconditions.argumentNotNull(uri, "Uri can't be null");
        DatabaseUriMatcher.Result match = this.matchInsertUri(uri);
        SQLiteDatabase db = this.mHelper.getWritableDatabase();
        try {
            db.beginTransaction();
            SqlInsertionBuilder builder = this.buildInsertion(uri, match, values);
            int conflictAlgorithm = DatabaseContentProvider.getConflictAlgorithm(uri);
            List<Long> generatedIds = builder.insert(db, conflictAlgorithm);
            this.notifyChange(uri);
            db.setTransactionSuccessful();
            int n = generatedIds.size();
            return n;
        }
        finally {
            db.endTransaction();
        }
    }

    @NonNull
    private DatabaseUriMatcher.Result matchInsertUri(@NonNull Uri uri) {
        DatabaseUriMatcher.Result match = this.matchUri(uri);
        if (match.isRow) {
            throw new UnsupportedOperationException("Can't insert into a row uri: " + uri);
        }
        return match;
    }

    @NonNull
    protected SqlInsertionBuilder buildInsertion(@NonNull Uri uri, @NonNull DatabaseUriMatcher.Result match, ContentValues ... values) {
        SqlInsertionBuilder builder = new SqlInsertionBuilder().setTable(match.table);
        if (values != null) {
            builder.appendValues(values);
        }
        return builder;
    }

    public int delete(@NonNull Uri uri, String selection, String[] selectionArgs) {
        Preconditions.argumentNotNull(uri, "Uri can't be null");
        DatabaseUriMatcher.Result match = this.matchUri(uri);
        SQLiteDatabase db = this.mHelper.getWritableDatabase();
        SqlSelectionBuilder builder = this.buildUpdateDeleteSelection(uri, match, selection, selectionArgs);
        int deletedRows = builder.delete(db);
        this.notifyChange(uri);
        return deletedRows;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, String selection, String[] selectionArgs) {
        Preconditions.argumentNotNull(uri, "Uri can't be null");
        Preconditions.argumentNotNull(values, "Values can't be null");
        Preconditions.argumentCondition(values.size() == 0, "Values can't be empty");
        DatabaseUriMatcher.Result match = this.matchUri(uri);
        SQLiteDatabase db = this.mHelper.getWritableDatabase();
        SqlSelectionBuilder builder = this.buildUpdateDeleteSelection(uri, match, selection, selectionArgs);
        int conflictAlgorithm = DatabaseContentProvider.getConflictAlgorithm(uri);
        int updatedRows = builder.update(db, values, conflictAlgorithm);
        this.notifyChange(uri);
        return updatedRows;
    }

    @NonNull
    public SqlSelectionBuilder buildUpdateDeleteSelection(@NonNull Uri uri, @NonNull DatabaseUriMatcher.Result match, @Nullable String selection, @Nullable String[] selectionArgs) {
        SqlSelectionBuilder builder = new SqlSelectionBuilder();
        switch (match.code) {
            case 1: {
                builder.where("_id = ?", match.id);
            }
            case 0: {
                builder.setTable(match.table).where(selection, selectionArgs);
            }
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ContentProviderResult[] applyBatch(@NonNull ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        Preconditions.argumentNotNull(operations, "Operations required");
        SQLiteDatabase db = this.mHelper.getWritableDatabase();
        db.beginTransaction();
        try {
            int operationCount = operations.size();
            ContentProviderResult[] operationResults = new ContentProviderResult[operationCount];
            for (int i = 0; i < operations.size(); ++i) {
                operationResults[i] = operations.get(i).apply((ContentProvider)this, operationResults, i);
            }
            db.setTransactionSuccessful();
            ContentProviderResult[] contentProviderResultArray = operationResults;
            return contentProviderResultArray;
        }
        finally {
            db.endTransaction();
        }
    }

    protected void notifyChange(@NonNull Uri uri) {
        Context context = this.getContext();
        if (context != null) {
            context.getContentResolver().notifyChange(uri, null);
        }
    }

    private static int getConflictAlgorithm(Uri uri) {
        String onConflict = uri.getQueryParameter(PARAM_CONFLICT_ALGORITHM);
        if (onConflict == null) {
            return 0;
        }
        return Integer.parseInt(onConflict);
    }
}

